/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

/*
	An abstract class for ProductionTasks (Tasks for the ProductionManager, which will either train units or build buildings)
*/

#pragma once

#include "../CommonIncludes.h"

#include "../ProductionManager.h"
#include "../Task.h"

class ProductionTask : public Task
{
private:
	BWAPI::UnitType productionType;
	int productionID;
	bool placedReservation;

public:
	ProductionTask(const int priority, BWAPI::UnitType productionType) :
	  Task(priority), productionType(productionType), productionID(ProductionManager::Instance()->getNextProductionID()),
	  placedReservation(false) {}

	void onStart()
	{
		ProductionManager* productionManager = ProductionManager::Instance();
		productionManager->placeGasReservation(Reservation(productionID, productionType.gasPrice()));
		productionManager->placeMineralReservation(Reservation(productionID, productionType.mineralPrice()));
	}

	void onEnd()
	{
		ProductionManager* productionManager = ProductionManager::Instance();
		productionManager->removeGasReservation(productionID);
		productionManager->removeMineralReservation(productionID);
	}

	const BWAPI::UnitType getProductionType() const
	{
		return productionType;
	}

	void setProductionType(BWAPI::UnitType type)
	{
		productionType = type;
	}
};