/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

/*
	A concrete Task to gather resources from a specific node.
*/

#pragma once

#include "../CommonIncludes.h"

#include "../MapAnalyser.h"
#include "../PositionUtils.h"
#include "../Priorities.h"
#include "../Task.h"
#include "../UnitTracker.h"

class GatherResourceTask : public Task
{
private:
	BWAPI::Unit worker;
	BWAPI::Unit resource;

public:
	GatherResourceTask(BWAPI::Unit worker, BWAPI::Unit resource) : 
	  Task(Priorities::PRIORITY_RESOURCE_GATHERING), worker(worker), resource(resource) {}

	inline const bool rescheduleIfInterrupted() const
	{
		return false;
	}

	void onEnd()
	{
		UnitTracker::Instance()->removeWorkerFromResource(worker, resource);
	}

	void onStart()
	{
		UnitTracker::Instance()->assignWorkerToResource(worker, resource);
	}

	inline const bool allowInterruption() const
	{
		return true;
	}

	inline const bool canExecute() const
	{
		return true;
	}

	void execute()
	{
		if(worker->isIdle() && (worker->isCarryingGas() || worker->isCarryingMinerals()))
			worker->returnCargo();
		else if(!worker->isGatheringGas() && !worker->isGatheringMinerals())
			worker->gather(resource);
	}

	inline const bool isFinished() const
	{
		return false;
	}

	const bool isValid() const
	{
		if(resource->getType().isMineralField())
			return resource->getResources() > 0;
		else
			return resource->getPlayer() == BWAPI::Broodwar->self();
	}

	inline const bool scheduleConditions() const
	{
		if(!worker || !resource)
			return false;

		return MapAnalyser::Instance()->pathExists(PositionUtils::toWalkPosition(worker->getPosition()), 
													PositionUtils::toWalkPosition(resource->getPosition()));
	}

#ifdef MAASCRAFT_DEBUG
	std::string getDescription() const
	{
		return (StringBuilder() << "Gathering resources...").getString();
	}
#endif
};