/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

/*
	A concrete Task to fight in a certain location
*/

#pragma once

#include "../CommonIncludes.h"

#include "../DebugDrawing.h"
#include "../Distances.h"
#include "../OpponentTracker.h"
#include "../Squad.h"
#include "../Task.h"
#include "../UnitBehaviours/CombatBehaviourFight.h"
#include "../UnitUtils.h"

#ifdef ARMY_MANAGER_UCT

class FightSquad : public Task
{
private:
	MapGraphNode* node;
	Squad* squad;

public:
	FightSquad(const int priority, Squad* squad, MapGraphNode* node) : 
	  Task(priority), node(node), squad(squad) {}

	inline const bool allowInterruption() const
	{
		return true;
	}

	inline const bool canExecute() const
	{
		return true;
	}

	BWAPI::Unitset getPotentialTargets(BWAPI::Unit squadMember) const
	{
		BWAPI::Unitset potentialTargets = UnitUtils::getUnitsInRadius(squadMember, 640, BWAPI::Filter::IsEnemy		&& 
																						(BWAPI::Filter::IsDetected || !BWAPI::Filter::IsVisible));

		if(potentialTargets.empty())
		{
			if(node->getType() == CHOKEPOINT)
			{
				potentialTargets = OpponentTracker::Instance()->getOpponentsInRegion(node->getChokePoint()->getRegions().first);

				if(potentialTargets.empty())
				{
					potentialTargets = OpponentTracker::Instance()->getOpponentsInRegion(node->getChokePoint()->getRegions().second);
				}
			}
			else
			{
				potentialTargets = OpponentTracker::Instance()->getOpponentsInRegion(node->getRegion());
			}
		}

		return potentialTargets;
	}

	void execute()
	{
		OpponentTracker* opponentTracker = OpponentTracker::Instance();
		const BWAPI::Unitset& units = squad->getOwnedUnits();

		for(auto it = units.begin(); it != units.end(); ++it)
		{
			const BWAPI::Unit unit = *it;

			if(Behaviours::combatBehaviourFight(unit))
			{
				continue;
			}
			else
			{
				BWAPI::UnitType unitType = unit->getType();

				if(unitType.groundWeapon() != BWAPI::WeaponTypes::None	&& 
					!(UnitUtils::getUnitsInWeaponRange(unit, unitType.groundWeapon(), BWAPI::Filter::IsEnemy && BWAPI::Filter::IsDetected)).empty())
				{
					if(!Behaviours::combatBehaviourFight(unit))
						LOG_WARNING(StringBuilder() << "Frame " << BWAPI::Broodwar->getFrameCount() << ": MoveSquad: Enemy in range but combatBehaviourFight() returns false!")
				}
				else if(unitType.airWeapon() != BWAPI::WeaponTypes::None	&& 
					!(UnitUtils::getUnitsInWeaponRange(unit, unitType.airWeapon(), BWAPI::Filter::IsEnemy && BWAPI::Filter::IsDetected)).empty())
				{
					if(!Behaviours::combatBehaviourFight(unit))
						LOG_WARNING(StringBuilder() << "Frame " << BWAPI::Broodwar->getFrameCount() << ": MoveSquad: Enemy in range but combatBehaviourFight() returns false!")
				}
				else
				{
					if(UnitUtils::canMove(unit) && (unit->isIdle() || unit->getLastCommand().getTargetPosition() != node->getPosition()))
					{
						BWAPI::Position squadPos = units.getPosition();

						if(Distances::getSquaredDistance(squadPos, unit->getPosition()) > 1024)
							unit->move(squadPos);
						else
							unit->move(node->getPosition());
					}
				}
			}
		}
	}

	inline const bool isFinished() const
	{
		return true;
	}

	const bool isValid() const
	{
		return true;
	}

	inline const bool scheduleConditions() const
	{
		return true;
	}

#ifdef MAASCRAFT_DEBUG
	std::string getDescription() const
	{
		return "Fight Squad";
	}
#endif
};

#endif // ARMY_MANAGER_UCT