/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

/*
	A concrete Task to choose a new transition
*/

#pragma once

#include "../CommonIncludes.h"

#include "../Predicates.h"
#include "../StrategyManager.h"
#include "../Task.h"

template <typename SchedulePred = Predicates::Tautology>
class ChooseTransition : public Task
{
public:
	ChooseTransition(const int priority) : 
	  Task(priority) {}

	inline const bool repeatTask() const
	{
		return false;
	}

	inline const bool allowInterruption() const
	{
		return false;
	}

	inline const bool canExecute() const
	{
		return true;
	}

	void execute()
	{
		StrategyManager::Instance()->transition();
	}

	inline const bool isFinished() const
	{
		return true;
	}

	const bool isValid() const
	{
		return true;
	}

	inline const bool scheduleConditions() const
	{
		return (SchedulePred()());
	}

#ifdef MAASCRAFT_DEBUG
	std::string getDescription() const
	{
		return "Choose a new transition!";
	}
#endif
};