/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

/*
	A concrete Task to assign a unit from the WorkerManager to the ScoutManager for scouting purposes
*/

#pragma once

#include "../CommonIncludes.h"

#include "../Predicates.h"
#include "../Priorities.h"
#include "../ScoutManager.h"
#include "../Task.h"
#include "../WorkerManager.h"

template <typename SchedulePred = Predicates::Tautology>
class AssignScoutWorker : public Task
{
private:
	BWAPI::Unit scout;
	bool finished;

public:
	AssignScoutWorker() : 
	  Task(Priorities::PRIORITY_SCOUTING), scout(nullptr), finished(false) {}

	inline const bool allowInterruption() const
	{
		return false;
	}

	inline const bool canExecute() const
	{
		return WorkerManager::Instance()->getOwnedUnits().size() >= 2;	// must leave at least one Worker to the WorkerManager for resource gathering
	}

	void execute()
	{
		if(!scout)
			scout = WorkerManager::Instance()->requestScout();

		if(scout && !finished)
		{
			WorkerManager::Instance()->transferOwnershipTo(scout, ScoutManager::Instance());
			finished = true;
		}
	}

	inline const bool isFinished() const
	{
		return finished;
	}

	const bool isValid() const
	{
		return true;
	}

	inline const bool scheduleConditions() const
	{
		return SchedulePred()();
	}

#ifdef MAASCRAFT_DEBUG
	std::string getDescription() const
	{
		return "Assigning Scout Worker from WorkerManager to ScoutManager";
	}
#endif
};