/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#pragma once

/*
	Interface to the Strategy Manager Singleton.
*/

#include "CommonIncludes.h"

#include "Task.h"
#include "TaskSet.h"

namespace Strategies
{
	static const int ANY_STRATEGY		= 0;

	// Openings
	static const int PvP_2_Gateways		= 1;

	// Mid Game
	static const int PvP_3_GateGoon		= 2;
}

class StrategyManager
{
public:
	static StrategyManager* Instance()
	{
		static StrategyManager instance;
		static StrategyManager* instance_ptr = &instance;
		return instance_ptr;
	}

	const int getCurrentStrategy();
	void transition();

	// convenience methods to affect the production manager's tasks
	void addTask(Task* task);
	void addTasks(const std::vector<Task*>& tasks);
	void clearTasks(const int maxClearPriority);

	const Task* getCurrentTask() const;

	// EVENTS
	void onFrame();
	void onStart();

	Task* requestNewWorkerTask(BWAPI::Unit worker);

private:
	TaskSet strategyManagerTaskSet;
	int currentStrategy;

	void startOpeningBuildOrder();

	StrategyManager() : strategyManagerTaskSet(), currentStrategy(Strategies::ANY_STRATEGY) {}
	StrategyManager(StrategyManager const &);
};