/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#include "CommonIncludes.h"

#include "ArmyManager.h"
#include "MidGame.h"
#include "OpeningBook.h"
#include "OpponentTracker.h"
#include "Squad.h"
#include "StrategyManager.h"
#include "UnitTracker.h"

/*
	Implementation of the StrategyManager
*/

using namespace BWAPI;
using namespace std;

const int StrategyManager::getCurrentStrategy()
{
	return currentStrategy;
}

void StrategyManager::onFrame()
{
	strategyManagerTaskSet.update();
	Task* currentTask = strategyManagerTaskSet.getCurrentTask();

	if(currentTask)
		currentTask->execute();
}

void StrategyManager::onStart()
{
	startOpeningBuildOrder();
}

void StrategyManager::startOpeningBuildOrder()
{
	// here some smart code should choose a build order from those available in OpeningBook
	// for now, ''smartly'' choose 2 Gateways
	currentStrategy = OpeningBook::PvP_2_Gateways();
}

void StrategyManager::transition()
{
	// ''smartly'' choose 3 Gate Goon
	currentStrategy = MidGame::PvP_3_GateGoon();
}

Task* StrategyManager::requestNewWorkerTask(Unit worker)
{
	return nullptr;
}

void StrategyManager::addTask(Task* task)
{
	strategyManagerTaskSet.addTask(task);
}

void StrategyManager::addTasks(const vector<Task*>& tasks)
{
	strategyManagerTaskSet.addTasks(tasks);
}

void StrategyManager::clearTasks(const int maxClearPriority)
{
	strategyManagerTaskSet.clearTasks(maxClearPriority);
}

const Task* StrategyManager::getCurrentTask() const
{
	return strategyManagerTaskSet.getCurrentTask();
}