/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#pragma once

/*
	A Squad is a collection of military units
*/

#include "CommonIncludes.h"

#include "Action.h"
#include "MapAnalyser.h"
#include "MapRegion.h"
#include "Task.h"
#include "TaskSet.h"
#include "UnitOwner.h"

#ifdef ARMY_MANAGER_UCT

class Squad : public UnitOwner
{
public:
	Squad();
	~Squad();

	const BWAPI::Unitset getOpponentsInRegion() const;
	const BWAPI::Unitset getPotentialTargets(BWAPI::Unit squadMember) const;
	const MapRegion* getRegion() const;
	const Task* getTask() const;
	const int getSize() const;
	const bool isInCombat() const;
	void setRegion(MapRegion* newRegion);
	void setTask(Action move);
	void setTask(Task* newTask);

	// EVENTS
	void onFrame();

private:
	Task* task;
	MapRegion* region;
	bool inCombat;
};

#endif // ARMY_MANAGER_UCT

#ifdef ARMY_MANAGER_SCRIPTED

class Squad : public UnitOwner
{
public:
	Squad() : squadTaskSet(), region(nullptr), inCombat(false) {}
	~Squad() {}

	const int getSize() const;

	const BWAPI::Unitset getOpponentsInRegion() const;
	const BWAPI::Unitset getPotentialTargets(BWAPI::Unit squadMember) const;
	const MapRegion* getRegion() const;
	const bool isInCombat() const;
	void setRegion(MapRegion* newRegion);

	// convenience methods to affect a Squad's tasks
	void addTask(Task* task);
	void addTasks(const std::vector<Task*>& tasks);
	void clearTasks(const int maxClearPriority);

	const Task* getCurrentTask() const;

	// EVENTS
	void onFrame();

private:
	TaskSet squadTaskSet;
	MapRegion* region;
	bool inCombat;
};

#endif // ARMY_MANAGER_SCRIPTED