/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#pragma once

/*
	An object to represent a Squad in a simulation
*/

#include "CommonIncludes.h"

#ifdef ARMY_MANAGER_UCT

#include <vector>

#include "BaseManager.h"
#include "MapGraph.h"
#include "MapGraphNode.h"

class SimSquad
{
public:
	SimSquad(const BWAPI::Unitset& units, const bool flyers);
	SimSquad(const Base& base);
	~SimSquad();

	const bool allowRetreat() const;

	MapGraphNode* getGraphNode() const;
	const BWAPI::Player getPlayer() const;
	BWAPI::Position getPosition() const;
	MapGraphNode* getPreviousNode() const;
	const BWAPI::Unitset& getUnits() const;
	const bool flyersOnly() const;

	const int getAirHP() const;
	const int getGroundHP() const;
	const float getAirDPS() const;
	const float getGroundDPS() const;
	const float getNumFlyers() const;
	const float getNumGroundUnits() const;
	const double getTopSpeed() const;
	const int getTrueAirHP() const;
	const int getTrueGroundHP() const;

	const bool isBase() const;
	const bool isIdle() const;
	const bool isInCombat() const;
	const bool isRetreating() const;

	void modAirHP(const int mod);
	void modGroundHP(const int mod);
	void modNumFlyers(const float mod);
	void modNumGroundUnits(const float mod);

	void setGraphNode(MapGraphNode* newNode);
	void setIdle(const bool status);
	void setInCombat(const bool status);
	void setNumFlyers(const int num);
	void setNumGroundUnits(const int num);
	void setPosition(const BWAPI::Position& pos);
	void setPreviousNode(MapGraphNode* node);
	void setRetreating(const bool status);

	void setAirHP(const int hp);
	void setGroundHP(const int hp);
	void setAirDPS(const float dps);
	void setGroundDPS(const float dps);

	void setStartsInCombat(const bool flag);
	const bool startedSimInCombat() const;

private:
	BWAPI::Unitset units;
	BWAPI::Position position;
	double topSpeed;
	BWAPI::Player player;
	MapGraphNode* graphNode;
	MapGraphNode* previousNode;
	int airHP;
	int groundHP;
	float numGroundUnits;
	float numFlyers;
	float airDPS;
	float groundDPS;
	bool flyers;
	bool idle;
	bool inCombat;
	bool retreating;
	bool base;
	bool startSimInCombat;
	bool retreatAllowed;
};

#endif // ARMY_MANAGER_UCT