/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#pragma once

/*
	A Battle in a UCT simulation
*/

#include "CommonIncludes.h"

#ifdef ARMY_MANAGER_UCT

#include <vector>

#include "GameState.h"
#include "MapGraphNode.h"

class GameState;

struct LanchesterValues
{
	double a;	// number of allied units killed per frame per enemy unit
	double b;	// number of enemy units killed per frame per allied unit
	double P;	// production rate of allied units per frame
	double Q;	// production rate of enemy units per frame
	double E;	// the E variable as defined in thesis
	double F;	// the F variable as defined in thesis

	LanchesterValues() :
		a(0.0), b(0.0), P(0.0), Q(0.0),
		E(0.0), F(0.0) {}
};

class SimBattle
{
public:
	SimBattle(MapGraphNode* node);
	~SimBattle();

	void addAllySquad(const int squadIndex, GameState& gameState);
	void addEnemySquad(const int squadIndex, GameState& gameState);
	void addAllyBase(const int baseIndex, GameState& gameState);
	void addEnemyBase(const int baseIndex, GameState& gameState);
	MapGraphNode* getGraphNode() const;
	const int getRemainingDuration() const;
	const bool isFinished() const;
	void recomputeRemainingDuration(GameState& gameState);
	void simulateBattle(const int frameDuration, GameState& gameState);

private:
	std::vector<int> allySquadIndices;
	std::vector<int> enemySquadIndices;
	std::vector<int> allyBaseIndices;
	std::vector<int> enemyBaseIndices;
	LanchesterValues lanchester;
	MapGraphNode* node;
	float totEnemyAirDPF;
	float totEnemyGroundDPF;
	float totSelfAirDPF;
	float totSelfGroundDPF;
	int totEnemyAirHP;
	int totEnemyGroundHP;
	int totSelfAirHP;
	int totSelfGroundHP;
	float totNumEnemyFlyers;
	float totNumEnemyGroundUnits;
	float totNumSelfFlyers;
	float totNumSelfGroundUnits;
	float totNumEnemyUnits;
	float totNumSelfUnits;
	int durationRemaining;
};

#endif // ARMY_MANAGER_UCT