/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#pragma once

/*
	Interface to the Scout Manager Singleton.
*/

#include "CommonIncludes.h"

#include <set>
#include <unordered_map>

#include "BaseLocation.h"
#include "Task.h"
#include "TaskSet.h"
#include "UnitOwner.h"
#include "UnitUtils.h"

class ScoutManager : public UnitOwner
{
public:
	static ScoutManager* Instance()
	{
		static ScoutManager instance;
		static ScoutManager* instance_ptr = &instance;
		return instance_ptr;
	}

	void receiveOwnership(const BWAPI::Unit unit);

	// convenience methods to affect the Scout Manager's tasks
	void addTask(Task* task);
	void addTasks(const std::vector<Task*>& tasks);
	void clearTasks(const int maxClearPriority);

	const Task* getCurrentTask() const;

	// EVENTS
	void onFrame();

private:
	TaskSet scoutManagerTaskSet;
	std::unordered_map<BWAPI::Unit, TaskSet, UnitUtils::HashFunctionUnit> unitTasksMap;

	ScoutManager() : UnitOwner(), scoutManagerTaskSet() {}
	~ScoutManager() {}

	Task* requestNewScoutTask(const BWAPI::Unit scout);

	ScoutManager(ScoutManager const &);
};