/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#pragma once

/*
	Simple utility class to make RNG a bit less painful to use in C++
*/

#include "CommonIncludes.h"

#include <random>
#include <time.h>

#pragma warning( push )
#pragma warning( disable:4244 )

namespace RNG
{
	class Generator
	{
	public:
		Generator() : mt()
		{
			mt.seed(time(nullptr));
		}

		inline const int randomInt(const int min, const int max)
		{
			std::uniform_int_distribution<int> distribution(min, max);
			return distribution(mt);
		}

	private:
		std::mt19937 mt;
	};

	const int randomInt(const int min, const int max);
}

#pragma warning( pop )