/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#pragma once

/*
	Some useful predicates
*/

namespace Predicates
{
	struct AlwaysTrue
	{
		inline bool operator() () const
		{
			return true;
		}
	};

	struct AlwaysFalse
	{
		inline bool operator() () const
		{
			return false;
		}
	};

	template<typename T>
	struct Equality
	{
		inline bool operator() (const T& first, const T& second) const
		{
			return (first == second);
		}
	};

	typedef AlwaysFalse Falsum;
	typedef AlwaysTrue Tautology;
}