/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

/*
	Utility functions for BWAPI Positions
*/

#pragma once
#include "CommonIncludes.h"

namespace PositionUtils
{
	static inline BWAPI::Position getCenterPosition(const BWAPI::TilePosition& tilePos)
	{
		return BWAPI::Position(tilePos.x * 32 + 16, tilePos.y * 32 + 16);
	}

	static inline BWAPI::Position getCenterPosition(const BWAPI::WalkPosition& walkPos)
	{
		return BWAPI::Position(walkPos.x * 8 + 4, walkPos.y * 8 + 4);
	}

	static inline BWAPI::Position leftTop(const BWAPI::TilePosition& tilePos)
	{
		return BWAPI::Position(tilePos.x * 32, tilePos.y * 32);
	}

	static inline BWAPI::Position rightBot(const BWAPI::TilePosition& tilePos)
	{
		return BWAPI::Position(tilePos.x * 32 + 31, tilePos.y * 32 + 31);
	}

	static inline BWAPI::Position toPosition(const BWAPI::TilePosition& tilePos)
	{
		return BWAPI::Position(tilePos.x * 32, tilePos.y * 32);
	}

	static inline BWAPI::Position leftTop(const BWAPI::WalkPosition& walkPos)
	{
		return BWAPI::Position(walkPos.x * 8, walkPos.y * 8);
	}

	static inline BWAPI::Position rightBot(const BWAPI::WalkPosition& walkPos)
	{
		return BWAPI::Position(walkPos.x * 8 + 7, walkPos.y * 8 + 7);
	}

	static inline BWAPI::Position toPosition(const BWAPI::WalkPosition& walkPos)
	{
		return BWAPI::Position(walkPos.x * 8, walkPos.y * 8);
	}

	static inline BWAPI::TilePosition toTilePosition(const BWAPI::Position& pos)
	{
		return BWAPI::TilePosition(pos.x / 32, pos.y / 32);
	}

	static inline BWAPI::TilePosition toTilePosition(const BWAPI::WalkPosition& walkPos)
	{
		return BWAPI::TilePosition(walkPos.x / 4, walkPos.y / 4);
	}

	static inline BWAPI::WalkPosition toWalkPosition(const BWAPI::Position& pos)
	{
		return BWAPI::WalkPosition(pos.x / 8, pos.y / 8);
	}

	static inline BWAPI::WalkPosition toWalkPosition(const BWAPI::TilePosition& pos)
	{
		return BWAPI::WalkPosition(pos.x * 4, pos.y * 4);
	}
}