/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	Starcraft Brood Wars bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#include <cmath>
#include <iostream>
#include "Point2D.h"

/*
Implementation of Point2D.h
*/

// Constructor with given coordinates
inline Point2D::Point2D(const double & px, const double & py) :
	x(px), y(py)
	{}

// Copy constructor
inline Point2D::Point2D(const Point2D & p) :
	x(p.x), y(p.y)
	{}

// Deconstructor
inline Point2D::~Point2D()
{}

/* =====================================================================
		OVERLOADED OPERATORS
   ===================================================================== */

// negate point
inline const Point2D Point2D::operator-() const
{
	return Point2D(-x, -y);
}

// test equality
inline const bool Point2D::operator==(const Point2D & p) const
{
	return ((x == p.x) && (y == p.y));
}

// test inequality
inline const bool Point2D::operator!=(const Point2D & p) const
{
	return ((x != p.x) || (y != p.y));
}

// addition assignment
inline Point2D & Point2D::operator+=(const Point2D & p)
{
	x += p.x;
	y += p.y;

	return (*this);
}

 // subtraction assignment
inline Point2D & Point2D::operator-=(const Point2D & p)
{
	x -= p.x;
	y -= p.y;

	return (*this);
}

 // multiplication assignment
inline Point2D & Point2D::operator*=(const double & scalar)
{
	x *= scalar;
	y *= scalar;

	return (*this);
}

// division assignment
inline Point2D & Point2D::operator/=(const double & scalar)
{
	double scalar_inv = 1/scalar;

	x *= scalar_inv;
	y *= scalar_inv;

	return (*this);
}

// multiplication
inline const Point2D Point2D::operator*(const double & scalar) const
{
	return Point2D(x * scalar, y * scalar);
}

// division
inline const Point2D Point2D::operator/(const double & scalar) const
{
	double scalar_inv = 1/scalar;

	return Point2D(x * scalar_inv, y * scalar_inv);
}

// addition
inline const Point2D Point2D::operator+(const Point2D & p) const
{
	return Point2D(x + p.x, y + p.y);
}

// subtraction
inline const Point2D Point2D::operator-(const Point2D & p) const
{
	return Point2D(x - p.x, y - p.y);
}
 
// dot product
inline const double Point2D::operator*(const Point2D & p) const
{
	return (x * p.x + y * p.y);
}

// output stream operator
inline std::ostream & operator<<(std::ostream & os, const Point2D & p)
{
	os << "(" << p.x << ", " << p.y << ")";
}


/* =====================================================================
		PUBLIC METHODS
   ===================================================================== */
inline const double Point2D::getLength() const
{
	return std::sqrt(x*x + y*y);
}
 
inline const double Point2D::getSquaredLength() const
{
	return (x*x + y*y);
}

inline const Point2D Point2D::getNormalizedPoint() const
{
	double scalar = 1 / (this -> getLength());
	return Point2D(x * scalar, y * scalar);
}

inline void Point2D::normalize()
{
	double scalar = 1 / (this -> getLength());

	x *= scalar;
	y *= scalar;
}