/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#pragma once

/*
	Interface to the Path Finder

	For every request for a path, an AStarSearch object will be returned which contains the path
	and can be iterated over.
*/

#include "CommonIncludes.h"

#include <forward_list>

#include "AStar.hpp"
#include "Custom_F_Functions.h"
#include "PositionState.h"

namespace PathFinder
{
	const float computeWalkablePathCost(const BWAPI::WalkPosition& start, const BWAPI::WalkPosition& goal);

	std::forward_list<PositionState> findWalkablePath(const BWAPI::WalkPosition& start, const BWAPI::WalkPosition& goal);
	std::forward_list<PositionState> findWalkablePathOptimal(const BWAPI::WalkPosition& start, const BWAPI::WalkPosition& goal);

	// WalkablePath: Quickly finds a near-optimal walkable path (where optimality means shortest distance)
	typedef AStar<
					PositionState, 
					PositionStateFunctions::Get_Cost_Euclidean,
					PositionStateFunctions::Get_Successors_Walkable<
							PositionStateFunctions::Get_Cost_Euclidean, 
							PositionStateFunctions::Goal_Distance_Estimate_Euclid_Dist,
							Custom_F_Functions::Epsilon_Admissible							>,
					PositionStateFunctions::Goal_Distance_Estimate_Euclid_Dist, 
					Custom_F_Functions::Epsilon_Admissible 
																								> WalkablePath;

	// WalkablePathOptimal: Finds a guaranteed optimal walkable path (where optimality means shortest distance)
	typedef AStar<
					PositionState, 
					PositionStateFunctions::Get_Cost_Euclidean,
					PositionStateFunctions::Get_Successors_Walkable<
							PositionStateFunctions::Get_Cost_Euclidean, 
							PositionStateFunctions::Goal_Distance_Estimate_Euclid_Dist,
							G_plus_H														>, 
					PositionStateFunctions::Goal_Distance_Estimate_Euclid_Dist
																								> WalkablePathOptimal;
}