/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#include "CommonIncludes.h"

#include "MapAnalyser.h"
#include "MathConstants.h"
#include "PathFinder.h"
#include "PositionState.h"

/*
	Implementation of the PathFinder
*/

using namespace BWAPI;
using namespace PathFinder;
using namespace std;

const float PathFinder::computeWalkablePathCost(const BWAPI::WalkPosition& start, const BWAPI::WalkPosition& goal)
{
	if(! MapAnalyser::Instance()->tilesConnected(start, goal))
		return MathConstants::MAX_FLOAT;

	WalkablePath engine(7);

	PositionState startState(start);
	PositionState goalState(goal);

	engine.setStartAndGoalStates(startState, goalState);

	while(!engine.foundSolution())
	{
		if(!engine.searchStep())	// path cannot be found
			break;
	}

	return engine.getSolutionCost();
}

forward_list<PositionState> PathFinder::findWalkablePath(const BWAPI::WalkPosition& start, const BWAPI::WalkPosition& goal)
{
	if(! MapAnalyser::Instance()->tilesConnected(start, goal))
		return forward_list<PositionState>();

	WalkablePath engine(7);

	PositionState startState(start);
	PositionState goalState(goal);

	engine.setStartAndGoalStates(startState, goalState);

	while(!engine.foundSolution())
	{
		if(!engine.searchStep())	// path cannot be found
			break;
	}

	return engine.getPath();
}

forward_list<PositionState> PathFinder::findWalkablePathOptimal(const BWAPI::WalkPosition& start, const BWAPI::WalkPosition& goal)
{
	if(! MapAnalyser::Instance()->tilesConnected(start, goal))
		return forward_list<PositionState>();

	WalkablePathOptimal engine(7);

	PositionState startState(start);
	PositionState goalState(goal);

	engine.setStartAndGoalStates(startState, goalState);

	while(!engine.foundSolution())
	{
		if(!engine.searchStep())	// path cannot be found
			break;
	}

	return engine.getPath();
}