/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

/*
	This file declares all global options which may be used throughout the program
	Options will be defined in Options.cpp
*/

#pragma once

#ifndef MAASCRAFT_VERSION
#define MAASCRAFT_VERSION 1.0

//#define MAASCRAFT_DEBUG			// Comment this line out in order to remove all debug-related code from compilation
//#define _COMPILE_TESTS_			// Comment this line out in order to remove all Tests from compilation

//#define ARMY_MANAGER_SCRIPTED
#define ARMY_MANAGER_UCT

#ifdef ARMY_MANAGER_UCT
	#ifdef ARMY_MANAGER_SCRIPTED
		#undef ARMY_MANAGER_SCRIPTED
	#endif
#endif

#define BATTLE_MODEL_LANCHESTER

#include "BWAPI.h"

namespace Options
{
	// Controls how fast the game runs
	extern const int GAME_SPEED;

	// Parameters for the UCT algorithm in the Army Manager
	namespace ArmyManagerUCT
	{
		extern const int FRAMES_PER_SEARCH;
		extern const int MS_PER_FRAME;
		extern const int MAX_SIM_TIME;
	}

	// Values for competition rules
	namespace CompetitionRules
	{
		extern const int MAX_MS_PER_FRAME;
	}

	// hardcoded values used in Map Analysis
	namespace MapAnalysis
	{
		extern const unsigned int CHOKE_MIN_OBSTACLE_SIZE;

		extern const unsigned int PRUNE_REGION_SIZE_THRESHOLD;
		extern const unsigned int PRUNE_CHOKE_SIZE_THRESHOLD;
	}

	// hardcoded values for ProductionManager
	namespace ProductionManager
	{
		extern const int MAX_FRAME_BLOCK_PRODUCTION;
		extern const int PYLON_SUPPLY_THRESHOLD;
		extern const int UPDATE_AVG_RESOURCE_GAIN_FRAME_COUNT;
	}

	// hardcoded values for Resource Gathering
	namespace ResourceGathering
	{
		extern const float WORKERS_PER_MINERAL_PATCH;
		extern const int WORKERS_PER_VESPENE_GAS_GEYSER;
	}

	// hardcoded values for Scouting
	namespace Scouting
	{
		extern const int SQUARED_MAX_EXPANSION_RADIUS;
	}

#	ifdef MAASCRAFT_DEBUG
	// All debug-related options
	namespace Debug
	{
		// This option controls whether or not manual control of units by the user is allowed
		extern const bool DEBUG_MANUAL_CONTROL;

		// This option controls whether or not to process commands entered by the user through the game's chat function
		extern const bool DEBUG_USER_COMMANDS;

		// Options related to drawing certain pieces of info on the screen
		namespace ScreenInfo
		{
			extern const bool DEBUG_ARMY_MANAGER_INFO;
			extern const bool DEBUG_DRAW_FPS;
			extern const bool DEBUG_PRODUCTION_MANAGER_INFO;
		}
	}
#	endif	// MAASCRAFT_DEBUG
}

#endif		// MAASCRAFT_VERSION