/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

/*
	This file defines all global options which may be used throughout the program
	These options are declared in Options.h
*/

#include "Options.h"

namespace Options
{
	// Lower values are faster. 0 is lowest/fastest possible value. Negative values set to Starcraft's default speed
	const int GAME_SPEED = 0;

	// Parameters for the UCT algorithm in the Army Manager
	namespace ArmyManagerUCT
	{
		const int FRAMES_PER_SEARCH		= 30;
		const int MS_PER_FRAME			= 15;
		const int MAX_SIM_TIME			= 2880;		// corresponds to 2 minutes @ 24FPS
	}

	// Values for competition rules
	namespace CompetitionRules
	{
		const int MAX_MS_PER_FRAME = 41;
	}

	// hardcoded values used in Map Analysis
	namespace MapAnalysis
	{
		const unsigned int CHOKE_MIN_OBSTACLE_SIZE		= 200;		// Skynet used this value in AIIDE 2012

		const unsigned int PRUNE_REGION_SIZE_THRESHOLD	= 1300;		// Experimentally determined
		const unsigned int PRUNE_CHOKE_SIZE_THRESHOLD	= 10;		// Experimentally determined
	}

	// hardcoded values for ProductionManager
	namespace ProductionManager
	{
		const int MAX_FRAME_BLOCK_PRODUCTION			= 36;		// allow production to block lower priority productions if we expect to have
																	//	sufficient resources within 36 frames (= ~1.5 sec at 24FPS)
		const int PYLON_SUPPLY_THRESHOLD				= 4;		// start producing a new Pylon if we have this amount remaining Supply
		const int UPDATE_AVG_RESOURCE_GAIN_FRAME_COUNT	= 240;		// update every 240 frames (= ~10 sec at 24FPS)
	}

	// hardcoded values for Resource Gathering
	namespace ResourceGathering
	{
		const float WORKERS_PER_MINERAL_PATCH			= 2.5f;		// From http://wiki.teamliquid.net/starcraft/Resources 
		const int WORKERS_PER_VESPENE_GAS_GEYSER		= 3;		// these values seem to be (near-)optimal
	}

	// hardcoded values for Scouting
	namespace Scouting
	{
		const int SQUARED_MAX_EXPANSION_RADIUS			= 2500;		// scout for expansion in a max radius of 50 build tiles around existing bases
	}

#ifdef MAASCRAFT_DEBUG
	// All debug-related options
	namespace Debug
	{
		// This option controls whether or not manual control of units by the user is allowed
		const bool DEBUG_MANUAL_CONTROL = true;

		// This option controls whether or not to process commands entered by the user through the game's chat function
		const bool DEBUG_USER_COMMANDS = true;

		// Options related to drawing certain pieces of info on the screen
		namespace ScreenInfo
		{
			const bool DEBUG_ARMY_MANAGER_INFO = false;
			const bool DEBUG_DRAW_FPS = true;
			const bool DEBUG_PRODUCTION_MANAGER_INFO = false;
		}
	}
#endif	// MAASCRAFT_DEBUG

}