/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#pragma once

/*
	Interface to the Opponent Tracker Singleton.
*/

#include "CommonIncludes.h"

#include <unordered_map>

#include "Clustering.h"
#include "MapAnalyser.h"
#include "MapRegion.h"
#include "UnitUtils.h"

class OpponentTracker
{
public:
	static OpponentTracker* Instance()
	{
		static OpponentTracker instance;
		static OpponentTracker* instance_ptr = &instance;
		return instance_ptr;
	}

	const float getAirThreat(const int tileX, const int tileY) const;
	const float getAirThreat(const BWAPI::Position& position) const;
	const float getAirThreat(const BWAPI::TilePosition& tilePos) const;
	const float getAirThreat(const BWAPI::WalkPosition& walkPos) const;

	const float getGroundThreat(const int tileX, const int tileY) const;
	const float getGroundThreat(const BWAPI::Position& position) const;
	const float getGroundThreat(const BWAPI::TilePosition& tilePos) const;
	const float getGroundThreat(const BWAPI::WalkPosition& walkPos) const;

	const int getNumUnits(const BWAPI::UnitType type) const;

	const int getLastHP(const BWAPI::Unit Unit) const;
	const BWAPI::Position getLastPosition(const BWAPI::Unit unit) const;
	const BWAPI::UnitType getLastType(const BWAPI::Unit unit) const;
	const bool wasCompleted(const BWAPI::Unit unit) const;

	const std::vector<BWAPI::Unitset>& getOpponentClusters() const;
	const BWAPI::Unitset& getOpponentDefensiveStructures() const;

	BWAPI::Unitset getOpponentsInRegion(const MapRegion* region) const;

	const std::unordered_map<BWAPI::Unit, UnitUtils::UnitData, UnitUtils::HashFunctionUnit>& getUnitDataMap() const;

	// EVENTS
	void onFrame();
	void onUnitDestroy(BWAPI::Unit unit);

private:
	OpponentTracker();
	~OpponentTracker();

	/*
		Threat in a certain cell for mobile units =
			0								if d > 2*maxRange
			2*DPS - DPS*d / maxRange		otherwise

		where d = distance from enemy unit to cell

		Threat in a certain cell for static units (e.g. defensive buildings) =
			0								if d > maxRange
			DPS - DPS*d / maxRange			otherwise
	*/
	float* airThreatMap;
	float* groundThreatMap;
	std::unordered_map<BWAPI::Unit, UnitUtils::UnitData, UnitUtils::HashFunctionUnit> buildingDataMap;
	std::unordered_map<BWAPI::UnitType, int, UnitUtils::HashFunctionUnitType> buildingTypeCounts;
	std::unordered_map<BWAPI::Unit, UnitUtils::UnitData, UnitUtils::HashFunctionUnit> unitDataMap;
	std::unordered_map<BWAPI::UnitType, int, UnitUtils::HashFunctionUnitType> unitTypeCounts;
	std::vector<BWAPI::Unitset> opponentClusters;
	BWAPI::Unitset opponentUnits;
	BWAPI::Unitset opponentBuildings;
	BWAPI::Unitset opponentDefensiveStructures;

	OpponentTracker(OpponentTracker const &);

	void computeClusters();
	const bool shouldRemoveUnitData(const UnitUtils::UnitData& unitData) const;
	void updateBuildingData();
	void updateThreatMaps();
	void updateUnitData();
	void validateOpponentUnits();
};