/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

/*
	Implementation of OpeningBook.h
*/

#include "CommonIncludes.h"

#include "BaseManager.h"
#include "OpeningBook.h"
#include "PositionUtils.h"
#include "Priorities.h"
#include "ProductionManager.h"
#include "ScoutManager.h"
#include "StrategyManager.h"
#include "Task.h"
#include "Tasks/AssignScoutWorker.hpp"
#include "Tasks/ChooseTransition.hpp"
#include "Tasks/ConstructBuilding.hpp"
#include "Tasks/ConstructBuildingAtDistance.hpp"
#include "Tasks/ConstructPylonForSupply.hpp"
#include "Tasks/TaskSchedulePreds.h"
#include "Tasks/SpamUnitsStrategy.hpp"
#include "Tasks/TrainProbes.hpp"
#include "Tasks/TrainUnit.hpp"
#include "Tasks/TrainUnits.hpp"

using namespace BWAPI;
using namespace std;

/*
	PROTOSS vs PROTOSS
*/
const int OpeningBook::PvP_2_Gateways()
{
	ProductionManager* productionManager = ProductionManager::Instance();
	ScoutManager* scoutManager = ScoutManager::Instance();

	// Train Probes
	productionManager->addTask(new TrainProbes(Priorities::PRIORITY_RESOURCE_GATHERING));

	// 2 Gateways at supply = 9
	productionManager->addTask(new ConstructBuilding<TaskSchedulePreds::AtOrAboveSupply<9>>
								(Priorities::PRIORITY_BASE_BUILDING_EARLY, UnitTypes::Protoss_Gateway));

	productionManager->addTask(new ConstructBuilding<TaskSchedulePreds::AtOrAboveSupply<9>>
								(Priorities::PRIORITY_BASE_BUILDING_EARLY, UnitTypes::Protoss_Gateway));

	// After constructing the 2 Gateways, send a Probe to scout
	scoutManager->addTask(new AssignScoutWorker<TaskSchedulePreds::AtOrAboveTotalUnitCount<UnitTypes::Enum::Protoss_Gateway, 2>>());

	// Spam Zealots and build Pylons as needed
	productionManager->addTask(new ConstructPylonForSupply(Priorities::PRIORITY_ARMY_BUILDING_EARLY + 2));

	productionManager->addTask(new SpamUnitsStrategy(Priorities::PRIORITY_ARMY_BUILDING_EARLY + 1, 
											UnitTypes::Protoss_Zealot, Strategies::PvP_2_Gateways));

	// Start third gateway after first 4th zealot in production
	productionManager->addTask(new ConstructBuilding<TaskSchedulePreds::AtOrAboveTotalUnitCount<UnitTypes::Enum::Protoss_Zealot, 4>>
								(Priorities::PRIORITY_BASE_BUILDING_EARLY, UnitTypes::Protoss_Gateway));

	// Build Assimilator and Cybernetics core when we have 4 or more zealots
	productionManager->addTask(new ConstructBuilding<TaskSchedulePreds::AtOrAboveCompletedUnitCount<UnitTypes::Enum::Protoss_Zealot, 4>>
										(Priorities::PRIORITY_ARMY_BUILDING_EARLY, UnitTypes::Protoss_Assimilator)						);

	productionManager->addTask(new ConstructBuilding<TaskSchedulePreds::AtOrAboveTotalUnitCount<UnitTypes::Enum::Protoss_Assimilator, 1>>
										(Priorities::PRIORITY_ARMY_BUILDING_EARLY, UnitTypes::Protoss_Cybernetics_Core)					);

	StrategyManager::Instance()->addTask(new ChooseTransition<TaskSchedulePreds::AtOrAboveCompletedUnitCount<UnitTypes::Enum::Protoss_Cybernetics_Core, 1>>
																										(Priorities::PRIORITY_BASE_BUILDING_MID));

	return Strategies::PvP_2_Gateways;
}