/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#pragma once

#include "CommonIncludes.h"

#include <vector>

#include "MapChokePoint.h"
#include "VectorUtils.h"

/*
	A MapRegion is either a full MapConnectedArea or a partial MapConnectedArea. It represents a portion
	of the map which, if connected to any other Regions, is connected to that other region through chokepoints.

	MapRegions will only be used for walkable ares, so there are no obstacle regions.
*/

class MapChokePoint;

class MapRegion
{
private:
	std::vector<BWAPI::WalkPosition> tiles;
	std::vector<MapChokePoint*> chokepoints;
	BWAPI::WalkPosition centroid;

	MapRegion(BWAPI::WalkPosition& centroid);

	// Only MapAnalyser may modify MapRegions.
	inline void addChokepoint(MapChokePoint* chokepoint)						{	chokepoints.push_back(chokepoint);		}

	inline void addTile(BWAPI::WalkPosition tile)								{	tiles.push_back(tile);					}
	inline void addTiles(const std::vector<BWAPI::WalkPosition>& newTiles)		{	VectorUtils::append(tiles, newTiles);	}

	MapRegion();
	MapRegion(MapRegion const &);

public:
	~MapRegion();

	inline const BWAPI::WalkPosition getCentroid() const					{	return centroid;	}
	inline const std::vector<MapChokePoint*>& getChokepoints()				{	return chokepoints;	}
	inline const std::vector<BWAPI::WalkPosition>& getTiles()				{	return tiles;		}

	void optimizeMemory();

friend class MapAnalyser;
};