/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#pragma once

/*
	A Node class to be used by MapGraph.h
*/

#include "CommonIncludes.h"

#include <vector>

#include "MapAnalyser.h"
#include "MapGraph.h"

enum MapNodeTypes
{
	BASE_LOCATION = 0,
	CHOKEPOINT = 1,
	OPEN_SPACE = 2
};

class MapGraphNode
{
public:
	MapGraphNode(const BWAPI::Position& position) :
	  edges(), position(position), type(OPEN_SPACE), chokePoint(nullptr), baseLoc(nullptr) {}

	MapGraphNode(const BWAPI::Position& position, MapChokePoint* chokePoint) :
	  edges(), position(position), type(CHOKEPOINT), chokePoint(chokePoint), baseLoc(nullptr) {}

	MapGraphNode(const BWAPI::Position& position, BaseLocation* baseLoc) :
	  edges(), position(position), type(BASE_LOCATION), chokePoint(nullptr), baseLoc(baseLoc) {}

	void addEdge(MapGraphEdge* edge);
	const int degree() const;
	BaseLocation* getBaseLoc() const;
	MapChokePoint* getChokePoint() const;
	const std::vector<MapGraphEdge*>& getEdges() const;
	const BWAPI::Position& getPosition() const;
	MapRegion* getRegion() const;
	const MapNodeTypes getType() const;
	const bool isAdjacentTo(const MapGraphNode* other) const;

private:
	std::vector<MapGraphEdge*> edges;
	BWAPI::Position position;
	MapNodeTypes type;
	MapChokePoint* chokePoint;
	BaseLocation* baseLoc;
};