/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

/*
	Implementation of MapGraphNode.h
*/

#include "CommonIncludes.h"

#include "MapGraphEdge.h"
#include "MapGraphNode.h"

void MapGraphNode::addEdge(MapGraphEdge* edge)
{
	edges.push_back(edge);
}

const int MapGraphNode::degree() const
{
	return edges.size();
}

BaseLocation* MapGraphNode::getBaseLoc() const
{
	return baseLoc;
}

MapChokePoint* MapGraphNode::getChokePoint() const
{
	return chokePoint;
}

const std::vector<MapGraphEdge*>& MapGraphNode::getEdges() const
{
	return edges;
}

const BWAPI::Position& MapGraphNode::getPosition() const
{
	return position;
}

MapRegion* MapGraphNode::getRegion() const
{
	return MapAnalyser::Instance()->getRegion(position);
}

const MapNodeTypes MapGraphNode::getType() const
{
	return type;
}

const bool MapGraphNode::isAdjacentTo(const MapGraphNode* other) const
{
	for(auto it = edges.begin(); it != edges.end(); ++it)
	{
		MapGraphEdge* edge = *it;

		if(edge->getOther(this) == other)
			return true;
	}

	return false;
}