/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#pragma once

/*
	An Edge class to be used by MapGraph.h
*/

#include "CommonIncludes.h"

#include "MapAnalyser.h"
#include "MapGraph.h"

class MapGraphEdge
{
public:
	MapGraphEdge(MapGraphNode* n1, MapGraphNode* n2, const int pixelFlyLength, const int pixelWalkLength) :
	  nodes(n1, n2), pixelFlyLength(pixelFlyLength), pixelWalkLength(pixelWalkLength) {}

	const std::pair<MapGraphNode*, MapGraphNode*>& getNodes() const;
	MapGraphNode* getOther(const MapGraphNode* const first) const;
	const int getFlyPixelLength() const;
	const int getWalkPixelLength() const;

private:
	std::pair<MapGraphNode*, MapGraphNode*> nodes;
	int pixelFlyLength;
	int pixelWalkLength;
};