/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

/*
	Implementation of MapGraphEdge.h
*/

#include "CommonIncludes.h"

#include "MapGraphEdge.h"

const std::pair<MapGraphNode*, MapGraphNode*>& MapGraphEdge::getNodes() const
{
	return nodes;
}

MapGraphNode* MapGraphEdge::getOther(const MapGraphNode* const first) const
{
	if(nodes.first == first)
		return nodes.second;
	else if(nodes.second == first)
		return nodes.first;

	LOG_WARNING("MapGraphEdge::getOther() called with an argument node which is not an endpoint of the edge!")
	return nullptr;
}

const int MapGraphEdge::getFlyPixelLength() const
{
	return pixelFlyLength;
}

const int MapGraphEdge::getWalkPixelLength() const
{
	return pixelWalkLength;
}