/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#pragma once

/*
	A small graph representation of the Map being played. Only contains MapChokePoint centers and
	MapRegion centroids as nodes.
*/

#include "CommonIncludes.h"

#include <unordered_map>
#include <vector>

#include "BaseLocation.h"
#include "MapChokePoint.h"
#include "MapRegion.h"

class BaseLocation;
class MapChokePoint;
class MapGraphNode;
class MapGraphEdge;

class MapGraph
{
public:
	MapGraph();
	~MapGraph();

	void createEdge(MapGraphNode* n1, MapGraphNode* n2);
	void initialize(const std::vector<MapRegion*>& mapRegions, const std::vector<MapChokePoint*>& chokes, const std::vector<BaseLocation*>& baseLocs);

	const std::vector<MapGraphEdge*>& getEdges() const;
	const std::vector<MapGraphNode*>& getNodes() const;
	const std::vector<MapGraphNode*>& getRegionNodes(MapRegion* region) const;

private:
	std::unordered_map<MapRegion*, std::vector<MapGraphNode*>> regions_to_nodes;
	std::vector<MapGraphEdge*> edges;
	std::vector<MapGraphNode*> nodes;
};