/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#pragma once

#include <vector>

#include "BWAPI.h"
#include "Options.h"
#include "VectorUtils.h"

/*
	A class to save information about a connected set of walk tiles
*/
class MapConnectedArea
{
private:
	bool obstacle;
	std::vector<BWAPI::WalkPosition> tiles;

	MapConnectedArea(bool obstacle);		// Only MapAnalyser should construct MapConnectedArea objects

	// Only MapAnalyser may modify ConnectedAreas.
	inline void addTile(BWAPI::WalkPosition tile)							{	tiles.push_back(tile);						}
	inline void addTiles(const std::vector<BWAPI::WalkPosition>& newTiles)	{	VectorUtils::append(tiles, newTiles);		}

	// No copy-constructor
	MapConnectedArea(MapConnectedArea const &);

public:
	~MapConnectedArea();

	inline bool isObstacle() const											{	return obstacle;																	}
	inline bool isSmallObstacle() const										{	return obstacle && tiles.size() < Options::MapAnalysis::CHOKE_MIN_OBSTACLE_SIZE;	}
	inline std::vector<BWAPI::WalkPosition>& getTiles()						{	return tiles;																		}

	// overloaded operators will be implemented in a Java-way, so 2 areas are only equal if they have the same memory address
	inline const bool operator==(const MapConnectedArea& other) const		{	return (this == &other);	}
	inline const bool operator!=(const MapConnectedArea& other) const		{	return (this != &other);	}

friend class MapAnalyser;
};