/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#pragma once

#include "CommonIncludes.h"

#include "MapRegion.h"
#include "Tuples.h"
#include "VectorUtils.h"

class MapRegion;

/*
	A MapChokePoint is a small area which connects two larger regions. Defined by a center walkable WalkPosition,
	and a vector of WalkPosition, which form the chokepoint in a straight line.
*/

class MapChokePoint
{
private:
	std::vector<BWAPI::WalkPosition> tiles;
	Pair<MapRegion*, MapRegion*> regions;
	BWAPI::WalkPosition center;

	MapChokePoint(BWAPI::WalkPosition center);

	inline void addTile(BWAPI::WalkPosition tile)								{	tiles.push_back(tile);						}
	inline void addTiles(const std::vector<BWAPI::WalkPosition>& newTiles)		{	VectorUtils::append(tiles, newTiles);		}

	MapChokePoint();
	MapChokePoint(MapChokePoint const &);

public:
	~MapChokePoint();

	inline const BWAPI::WalkPosition getCenter() const						{	return center;		}
	inline Pair<MapRegion*, MapRegion*>& getRegions()						{	return regions;		}
	inline const std::vector<BWAPI::WalkPosition>& getTiles()				{	return tiles;		}

	inline MapRegion* getOtherRegion(const MapRegion* firstRegion)
	{
		if(firstRegion == regions.first)
			return regions.second;
		else if(firstRegion == regions.second)
			return regions.first;
		else
		{
			LOG_WARNING("MapChokePoint::getOtherRegion() called with argument which is neither first nor second in pair!")
			LOG_MESSAGE(StringBuilder() << "Argument = " << firstRegion->getCentroid().x << ", " << firstRegion->getCentroid().y)
			LOG_MESSAGE(StringBuilder() << "First = " << regions.first->getCentroid().x << ", " << regions.first->getCentroid().y)
			LOG_MESSAGE(StringBuilder() << "Second = " << regions.second->getCentroid().x << ", " << regions.second->getCentroid().y)
			return nullptr;
		}
	}

	void optimizeMemory();

friend class MapAnalyser;
};