/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#pragma once

#include <fstream>

#include "BWAPI.h"
#include "Options.h"
#include "StringBuilder.h"

#define NOMINMAX
#include <Windows.h>

#ifdef MAASCRAFT_DEBUG
#define LOG_TO_FILE
#endif

//#ifdef LOG_TO_FILE
#define LOG_MEMORY_USAGE() Logger::Instance().dumpMemoryUsage();
#define LOG_MESSAGE(message) Logger::Instance().log(message);
#define LOG_WARNING(message) Logger::Instance().logWarning(message);
//#else
//	#define LOG_MEMORY_USAGE() (__noop)
//	#define LOG_MESSAGE(ignore) (__noop)
//	#define LOG_WARNING(ignore) (__noop)
//#endif

class Logger
{
public:
	// Returns the singleton Logger instance
	static Logger& Instance()
	{
		static Logger instance;
		return instance;
	}

	inline void dumpMemoryUsage()
	{
#ifdef LOG_TO_FILE
		MEMORYSTATUSEX statex;
		statex.dwLength = sizeof (statex);
		GlobalMemoryStatusEx (&statex);

		LOG_MESSAGE("-------------------------------- MAASCRAFT Memory Usage: --------------------------------")
		LOG_MESSAGE(StringBuilder() << "There is  " << statex.dwMemoryLoad << " percent of memory in use.")
		LOG_MESSAGE(StringBuilder() << "There are  " << statex.ullTotalPhys/1024 << " total KB of physical memory.")
		LOG_MESSAGE(StringBuilder() << "There are  " << statex.ullAvailPhys/1024 << " free  KB of physical memory.")
		LOG_MESSAGE(StringBuilder() << "There are  " << statex.ullTotalPageFile/1024 << " total KB of paging file.")
		LOG_MESSAGE(StringBuilder() << "There are  " << statex.ullAvailPageFile/1024 << " free  KB of paging file.")
		LOG_MESSAGE(StringBuilder() << "There are  " << statex.ullTotalVirtual/1024 << " total KB of virtual memory.")
		LOG_MESSAGE(StringBuilder() << "There are  " << statex.ullAvailVirtual/1024 << " free  KB of virtual memory.")
		LOG_MESSAGE(StringBuilder() << "There are  " << statex.ullAvailExtendedVirtual/1024 << " free  KB of extended memory.")
		LOG_MESSAGE("-----------------------------------------------------------------------------------------")
#endif
	}

	inline void log(const std::string &message)
	{
#ifdef LOG_TO_FILE
		std::ofstream output("bwapi-data\\AI\\MaasCraft\\MaasCraft.log", std::ios::ate | std::ios::app);
		output << BWAPI::Broodwar->getFrameCount() << " : " << message << std::endl;
		output.close();
#endif
	}

	inline void logWarning(const std::string &message)
	{
#ifdef LOG_TO_FILE
		std::ofstream output("bwapi-data\\AI\\MaasCraft\\MaasCraft.log", std::ios::ate | std::ios::app);
		output << BWAPI::Broodwar->getFrameCount() << " : " << message << std::endl;
		output.close();

		BWAPI::Broodwar << "WARNING: " << message << std::endl;
#endif
	}

private:
	Logger()
	{
#ifdef LOG_TO_FILE
		std::ofstream output("bwapi-data\\AI\\MaasCraft\\MaasCraft.log", std::ios::trunc);
		output.close();
#endif
	}

	~Logger()	{}

	Logger(Logger const &);
	void operator=(Logger const &);
};