/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#pragma once

/*
	An object to contain the Game's state during a simulation
*/

#include "CommonIncludes.h"

#ifdef ARMY_MANAGER_UCT

#include <set>
#include <vector>

#include "Action.h"
#include "SimBattle.h"
#include "SimSquad.h"
#include "Squad.h"

class SimBattle;

struct ActionOrderPred
{
	const bool operator() (const Action& a1, const Action& a2) const
	{
		return (a1.durationRemaining() < a2.durationRemaining());
	}
};

struct GameStateHitPoints
{
	int totalHPEnemy;
	int totalHPSelf;

	GameStateHitPoints(int enemyHP, int selfHP) : totalHPEnemy(enemyHP), totalHPSelf(selfHP) {}
};

class GameState
{
public:
	GameState();
	~GameState();

	void applyAction(Action move);
	void computeBattleDurations();
	void computeBattleLocations();
	GameStateHitPoints computeHitPoints() const;
	const int getFrame() const;
	std::vector<Action> getActions() const;
	std::vector<Action> getActionsAllied(const SimSquad& squad, const int index) const;
	std::vector<Action> getActionsEnemy(const SimSquad& squad, const int index) const;
	BWAPI::Player getPlayerToMove() const;
	Action getRandomAction() const;
	const double getReward(GameState& startState, GameStateHitPoints& startStateHP) const;
	const bool isTerminal() const;
	void resolveActions();

	std::vector<SimSquad>& getSelfSquads();
	std::vector<SimSquad>& getEnemySquads();
	std::vector<SimSquad>& getSelfBases();
	std::vector<SimSquad>& getEnemyBases();

	void reset(const std::vector<BWAPI::Unitset>& selfAirSquads, const std::vector<BWAPI::Unitset>& selfGroundSquads);

#ifdef MAASCRAFT_DEBUG
	void dumpInfo() const;
	void visualize() const;
#endif

private:
	std::multiset<Action, ActionOrderPred> scheduledActions;
	std::vector<SimBattle> battles;
	std::vector<SimSquad> selfSquads;
	std::vector<SimSquad> enemySquads;
	std::vector<SimSquad> selfBases;
	std::vector<SimSquad> enemyBases;
	mutable BWAPI::Player playerToMove;
	int frame;
	int enemyReverseActions;
	int selfReverseActions;
	bool terminate;
};

#endif // ARMY_MANAGER_UCT