/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#pragma once

/*
	Declaration of some convenience functions to make BWAPI's drawing functionality easier to use

	This entire file will be disabled if MAASCRAFT_DEBUG (in Options.h) is undefined
*/

#include "CommonIncludes.h"

#include "BWAPI/Color.h"

#ifdef MAASCRAFT_DEBUG

#include <forward_list>

#include "PathFinder.h"

namespace DebugDrawing
{
	void colorPosition(const BWAPI::Position& pos, const BWAPI::Color& color);
	void colorTilePosition(const BWAPI::TilePosition& pos, const BWAPI::Color& color);
	void colorWalkPosition(const BWAPI::WalkPosition& pos, const BWAPI::Color& color);

	void drawBoxAroundUnit(const BWAPI::Unit unit, const BWAPI::Color& color);
	void drawBoxesAroundUnits(const BWAPI::Unitset& unitset, const BWAPI::Color& color);

	void drawLineMap(const BWAPI::Position& pos1, const BWAPI::Position& pos2, const BWAPI::Color color);

	void drawPath(std::forward_list<PositionState>& path, const BWAPI::Color& color);

	void drawUnitHealthBar(const BWAPI::Unit unit);

	void linkUnits(const BWAPI::Unit u1, const BWAPI::Unit u2, const BWAPI::Color& color);
	void linkUnitsToPos(const BWAPI::Position pos, const BWAPI::Unitset& units, const BWAPI::Color& color);
	void linkUnitsToRoot(const BWAPI::Unit root, const BWAPI::Unitset& units, const BWAPI::Color& color);

	/*
	A simple class which can iterate over a set of predefined Debug colors.

	If for a certain purpose a set of different colors is required, a new iterator specific to that
	purpose can be created and then queried for colors.
	*/
	class ColorIterator
	{
	public:

		ColorIterator();
		~ColorIterator();

		const BWAPI::Color nextColor();

	private:

		unsigned int index;

		const static BWAPI::Color colors[];
	};
}

#else

namespace DebugDrawing
{
	void drawLineMap(const BWAPI::Position& pos1, const BWAPI::Position& pos2, const BWAPI::Color color);
}

#endif	// MAASCRAFT_DEBUG