/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#pragma once

/*
	Custom functions to compute f from g and h in the A* algorithm

	Default: f = g + h
*/

namespace Custom_F_Functions
{
	// f = g + 1.00001*h
	// Guarantees path which is at most 1.00001 times as expensive as the optimal path
	struct Epsilon_Admissible
	{
		float operator() (const float g, const float h) const
		{
			return g + 1.00001f*h;
		}
	};
}