/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#pragma once

/*
	Interface to algorithms which can be used to cluster BWAPI::Unit objects
*/

#include "CommonIncludes.h"

#include "VectorUtils.h"

namespace Clustering
{

	/*
		Returns a single cluster of Units around a given root Unit.

		root				= The given root unit around which we should find a cluster

		searchSpace			= All the units of which we should investigate whether or not they are in the cluster. MUST contain root

		radius				= Max distance at which a Unit or subcluster of Units is considered to be part of the main cluster

		clusterThreshold	= Minimum number of Units required to start a cluster
	*/
	BWAPI::Unitset getClusterForUnit(const BWAPI::Unit root, const BWAPI::Unitset& searchSpace, 
										const double radius, const size_t clusterThreshold		);

	/*
		Returns clusters for all units in searchSpace
	*/
	std::vector<BWAPI::Unitset> getClustersForUnits(const BWAPI::Unitset& searchSpace, 
													const double radius, const size_t clusterThreshold);

	/*
		Returns clusters for all units in searchSpace, where Units must be inside the same region in order to form a cluster
	*/
	std::vector<BWAPI::Unitset> getClustersForUnitsSameRegion(const BWAPI::Unitset& searchSpace, 
																const double radius, const size_t clusterThreshold);
}