/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#pragma once

/*
	Interface to the Base Manager Singleton.
*/

#include "CommonIncludes.h"

#include <vector>

#include "Base.h"
#include "BaseLocation.h"

class BaseManager
{
public:
	static BaseManager* Instance()
	{
		static BaseManager instance;
		static BaseManager* instance_ptr = &instance;
		return instance_ptr;
	}

	void addBase(Base newBase);

	const BaseLocation* getMainBaseLocation();
	void setMainBaseLocation(BaseLocation* mainBaseLoc);

	const bool hasBaseAtLocation(const BWAPI::Player player, const BaseLocation* baseLoc) const;
	Base getBaseAtLocation(const BWAPI::Player player, BaseLocation* baseLoc) const;

	inline const size_t getMaxNumWorkers()				{	return maxNumWorkers;	}

	inline const std::vector<Base>& getOpponentBases()	{	return opponentBases;	}
	inline const std::vector<Base>& getSelfBases()		{	return selfBases;		}

	std::vector<BaseLocation*> getScoutLocations();

	void updateMaxNumWorkers();

	// EVENTS
	void onFrame();
	void onOpponentBuildingDestroy(BWAPI::Unit building);
	void onOpponentBuildingShow(BWAPI::Unit building);
	void onSelfBuildingComplete(BWAPI::Unit building);
	void onSelfBuildingDestroy(BWAPI::Unit building);

private:
	std::vector<Base> opponentBases;
	std::vector<Base> selfBases;
	BaseLocation* mainBase;
	size_t maxNumWorkers;
	int lastAttack;

	BaseManager() : opponentBases(), selfBases(), mainBase(nullptr), maxNumWorkers(0), lastAttack(-100) {}

	BaseManager(BaseManager const &);
};