/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#pragma once

/*
	A BaseLocation is defined by a region number in which the BaseLocation resides, a set of resource Units,
	and an optimal location to place a Resource Depot
*/

#include "CommonIncludes.h"

class MapRegion;

class BaseLocation
{
public:
	BaseLocation(BWAPI::Unitset& resources, BWAPI::TilePosition& optimalDepotLocation, const short regionNumber);

	inline const BWAPI::TilePosition getOptimalDepotLocation() const	{	return optimalDepotLocation;	}
	MapRegion* getRegion() const;
	inline const short getRegionNumber() const							{	return regionNumber;			}
	inline const BWAPI::Unitset& getResources() const					{	return resources;				}

	inline const bool isCurrentScoutTarget() const						{	return scoutTarget;				}
	void setCurrentScoutTarget(const bool isTarget);

	const int getLastObserved();
	void setLastObserved(const int frame);

	inline const bool isStartLocation() const							{	return startLocation;			}
	void setStartLocation(const bool start);


private:
	BWAPI::Unitset resources;
	BWAPI::TilePosition optimalDepotLocation;
	int lastObserved;
	short regionNumber;
	bool startLocation;
	bool scoutTarget;

	BaseLocation();
};