/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

/*
	Implementation of BaseLocation.h
*/

#include "CommonIncludes.h"

#include "BaseLocation.h"
#include "MapAnalyser.h"
#include "MapRegion.h"

BaseLocation::BaseLocation(BWAPI::Unitset& resources, BWAPI::TilePosition& optimalDepotLocation, const short regionNumber) :
	resources(resources), optimalDepotLocation(optimalDepotLocation), lastObserved(0), regionNumber(regionNumber), 
	startLocation(false), scoutTarget(false) {}

MapRegion* BaseLocation::getRegion() const
{
	return MapAnalyser::Instance()->getRegion(regionNumber);
}

const int BaseLocation::getLastObserved()
{
	return lastObserved;
}

void BaseLocation::setCurrentScoutTarget(const bool isTarget)
{
	scoutTarget = isTarget;
}

void BaseLocation::setLastObserved(const int frame)
{
	lastObserved = frame;
}

void BaseLocation::setStartLocation(const bool start)
{
	startLocation = start;
}