/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#pragma once

/*
	Class to describe a Base which has been built already in a BaseLocation.
*/

#include "CommonIncludes.h"

#include "BaseLocation.h"

class Base
{
private:
	BWAPI::Unitset buildings;
	BaseLocation* location;
	BWAPI::Player owner;

public:
	Base(BaseLocation* location, BWAPI::Player owner) :
	  buildings(), location(location), owner(owner) {}

	void addBuilding(BWAPI::Unit building);
	const bool removeBuilding(BWAPI::Unit building);		// returns true if this was the last building

	inline const BWAPI::Unitset& getBuildings() const	{	return buildings;	}
	inline BaseLocation* getLocation() const			{	return location;	}
	inline const BWAPI::Player getOwner() const			{	return owner;		}

	BWAPI::Position getDepotCenter() const;

	const bool purelyDefensive() const;

	void setOwner(BWAPI::Player player);
};