/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

/*
	Implementation of Base.h
*/

#include "CommonIncludes.h"

#include "Base.h"
#include "OpponentTracker.h"
#include "PositionUtils.h"

using namespace BWAPI;

void Base::addBuilding(Unit building)
{
	buildings.push_back(building);
}

const bool Base::removeBuilding(Unit building)
{
	buildings.erase(building);

	return (buildings.size() == 0);
}

void Base::setOwner(Player player)
{
	owner = player;
}

Position Base::getDepotCenter() const
{
	// take true position of depot if one was built in this base
	for(auto it = buildings.begin(); it != buildings.end(); ++it)
	{
		Unit building = *it;
		if(building->getType().isResourceDepot())
		{
			if(owner == Broodwar->self())
				return (building->getPosition());
			else
				return OpponentTracker::Instance()->getLastPosition(building);
		}
	}

	// didn't find a depot, so return optimal depot position of base location instead
	return PositionUtils::toPosition(location->getOptimalDepotLocation() + (UnitTypes::Protoss_Nexus.tileSize() / 2));
}

const bool Base::purelyDefensive() const
{
	if(owner == Broodwar->enemy())
	{
		OpponentTracker* opponentTracker = OpponentTracker::Instance();

		for(auto it = buildings.begin(); it != buildings.end(); ++it)
		{
			UnitType type = opponentTracker->getLastType(*it);

			if(type != UnitTypes::Protoss_Photon_Cannon		&&
				type != UnitTypes::Terran_Bunker			&&
				type != UnitTypes::Terran_Missile_Turret	&&
				type != UnitTypes::Zerg_Spore_Colony		&&
				type != UnitTypes::Zerg_Sunken_Colony			)
			{
				return false;
			}
		}
	}
	else
	{
		for(auto it = buildings.begin(); it != buildings.end(); ++it)
		{
			UnitType type = (*it)->getType();

			if(type != UnitTypes::Protoss_Photon_Cannon)
			{
				return false;
			}
		}
	}

	return true;
}