/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#pragma once

/*
	Interface to the Army Manager Singleton.
*/

#include "CommonIncludes.h"

#include <vector>

#include "Squad.h"

#ifdef ARMY_MANAGER_UCT

#include "UCT.h"
#include "UnitOwner.h"

class ArmyManager : public UnitOwner
{
public:
	static ArmyManager* Instance()
	{
		static ArmyManager instance;
		static ArmyManager* instance_ptr = &instance;
		return instance_ptr;
	}

	void commandLooseUnits();
	const BWAPI::Unitset getPotentialTargets(BWAPI::Unit squadMember) const;
	void newEnemyBaseObserved() const;
	const bool shouldWorkersDefend() const;

	// EVENTS
	void onFrame(const float allowedMilliSeconds);
	void onUnitComplete(BWAPI::Unit unit);

#ifdef MAASCRAFT_DEBUG
	UCT& getSearchEngine()	{	return searchEngine;	}
#endif

private:
	UCT searchEngine;
	std::vector<Squad*> airSquads;
	std::vector<Squad*> groundSquads;

	ArmyManager();
	~ArmyManager();

	ArmyManager(ArmyManager const &);
};

#endif // ARMY_MANAGER_UCT

#ifdef ARMY_MANAGER_SCRIPTED

class ArmyManager
{
public:
	static ArmyManager* Instance()
	{
		static ArmyManager instance;
		static ArmyManager* instance_ptr = &instance;
		return instance_ptr;
	}

	const std::vector<Squad*>& getAirSquads();
	const std::vector<Squad*>& getDefensiveSquads();
	const std::vector<Squad*>& getGroundSquads();

	const bool isAttacking() const;
	const bool isRetreating() const;

	void newEnemyBaseObserved() const;

	Task* requestTask(Squad* squad) const;
	void transferUnitToDefensiveSquad(Squad* previousSquad, const BWAPI::Unit unit);

	// EVENTS
	void onFrame();
	void onUnitComplete(BWAPI::Unit unit);

	inline const bool shouldPlayOffensive()	{	return playOffensive;	}
	const bool shouldWorkersDefend() const;

private:
	std::vector<Squad*> airSquads;
	std::vector<Squad*> defensiveSquads;
	std::vector<Squad*> groundSquads;
	bool attacking;
	bool retreating;
	bool playOffensive;

	ArmyManager();
	~ArmyManager();

	ArmyManager(ArmyManager const &);
};

#endif // ARMY_MANAGER_SCRIPTED