/*	-----------------------------------------------------------------------------
	M A A S C R A F T

	StarCraft: Brood War - Bot

	Author: Dennis Soemers
	Maastricht University
	-----------------------------------------------------------------------------
*/

#pragma once

/*
	A move to be played during UCT's simulation
*/

#include "CommonIncludes.h"

#ifdef ARMY_MANAGER_UCT

#include "MapGraphEdge.h"
#include "MapGraphNode.h"

enum ActionTypes
{
	DO_NOTHING = 0,
	MOVE_TO = 1,
	FIGHT = 2,
	RETREAT_TO = 3,
	RESOLVE_ACTIONS = 4
};

class Action
{
public:
	Action(MapGraphEdge* edge, MapGraphNode* destination, ActionTypes type, const int duration, const int squadIndex);
	~Action();

	MapGraphEdge* edge() const								{	return _edge;								}
	MapGraphNode* destination() const						{	return _destination;						}
	ActionTypes type() const								{	return _type;								}
	int durationRemaining() const							{	return _durationRemaining;					}
	int squadIndex() const									{	return _squadIndex;							}

	void setEdge(MapGraphEdge* edge)						{	_edge = edge;								}
	void setDestination(MapGraphNode* destination)			{	_destination = destination;					}
	void setType(ActionTypes type)							{	_type = type;								}
	void setDurationRemaining(int durationRemaining) const	{	_durationRemaining = durationRemaining;		}
	void setSquadIndex(int squadIndex)						{	_squadIndex = squadIndex;					}

	static const Action NULL_ACTION;

	const bool operator==(const Action& other) const
	{
		return _destination == other.destination() && _type == other.type() && _squadIndex == other.squadIndex();
	}

private:
	MapGraphEdge* _edge;
	MapGraphNode* _destination;
	ActionTypes _type;
	mutable int _durationRemaining;
	int _squadIndex;

	Action();
};

namespace std
{
	template <> 
	struct hash<Action>
	{
		size_t operator()(const Action& action) const
		{
			return std::hash<size_t>()((action.squadIndex() + 1) * (action.type() + 1) * std::hash<MapGraphNode*>()(action.destination()));
		}
	};
}

#endif // ARMY_MANAGER_UCT