#include "Common.h"
#include "ScoutManager.h"
#include "InformationManager.h"

ScoutManager::ScoutManager( int totalSCV)
{

	for(int i=0; i<totalSCV; i++){
		Scout newScout;
		newScout.scv = CCmanager[0]->getBuilder();
		if(  newScout.scv == NULL){
			continue; 
		}
		newScout.TileTarget = InfoMan->PossibleBase[i%InfoMan->PossibleBase.size()];
		newScout.Target = BWAPI::Position( newScout.TileTarget );
		newScout.scv->move( newScout.Target );

		workerScouts.push_back( newScout );
		Broodwar->printf("scout added to %d", newScout.Target.x() );

	}

	/*
	if( InfoMan->EnemyBase != BWAPI::TilePositions::Unknown && WAMan == NULL ){
		Broodwar->printf( "Base found" );
		WAMan = new WorkerAttackManager();
	}
	*/

}


void ScoutManager::OnFrame(){


	for(unsigned int i=0; i<workerScouts.size(); i++){
		workerScouts[i].scv->move(workerScouts[i].Target);
		//Broodwar->drawBox(CoordinateType::Map,workerScouts[i].Target.x(),workerScouts[i].Target.y(),workerScouts[i].Target.x()+4*32,workerScouts[i].Target.y()+4*32,Colors::Orange,true);
		//Broodwar->drawBox(CoordinateType::Map,100,100,110,110,Colors::Orange,true);
		if( Broodwar->isVisible( workerScouts[i].TileTarget ) ){
			bool depot = false;
			//Broodwar->enemy()->getUnits()
			BOOST_FOREACH(BWAPI::Unit*  enemy,  Broodwar->enemy()->getUnits() ) {
				if( enemy->getType().isResourceDepot() && enemy->getTilePosition() ==  workerScouts[i].TileTarget ){
					depot = true;
				}
			}
            if( !depot ){
				Broodwar->printf( "No base here" );
				InfoMan->NoBaseHere( workerScouts[i].TileTarget );
				workerScouts[i].TileTarget = InfoMan->PossibleBase[ workerScouts.size() % InfoMan->PossibleBase.size()];
				workerScouts[i].Target = BWAPI::Position( workerScouts[i].TileTarget );
			} 
			else {
			  //InfoMan->EnemyBase = workerScouts[i].TileTarget;
			  InfoMan->setLocationEnemyBase( workerScouts[i].TileTarget );
			}
			if(  InfoMan->PossibleBase.size() == 1){//Base found by process of elimination
				//InfoMan->EnemyBase =  InfoMan->PossibleBase[0];
				InfoMan->setLocationEnemyBase( InfoMan->PossibleBase[0] );
			}
		}
	}

	
	if( CurrentStrategy == Worker_Rush &&  InfoMan->EnemyBase != BWAPI::TilePositions::Unknown && WAMan == NULL && Broodwar->getFrameCount() > 4 ){
		Broodwar->printf( "Base found" );
		WAMan = new WorkerAttackManager();
	}
	if( (CurrentStrategy == Bunker_Rush || CurrentStrategy == Bunker_Rush_Two) &&  InfoMan->EnemyBase != BWAPI::TilePositions::Unknown && BRMan == NULL && Broodwar->getFrameCount() > 4 ){
		Broodwar->printf( "Base found" );
		BRMan = new BunkerRushManager();
	}	
	if( CurrentStrategy == Gas_Steal &&  InfoMan->EnemyBase != BWAPI::TilePositions::Unknown && BRMan == NULL && GasStealMan == NULL && Broodwar->getFrameCount() > 4 ){
		Broodwar->printf( "Base found" );
		/*
		if( workerScouts.size() > 0 ){
		  GasStealMan = new GasStealManager( workerScouts[0].scv );
		  workerScouts.erase(  workerScouts.begin() );
		}
		*/
		GasStealMan = new GasStealManager();//will remove 1 scouting scv from workerScouts
		BRMan = new BunkerRushManager();
		CurrentStrategy = Bunker_Rush;//once the gas steal begins, transition into bunker rush
	}
	if( CurrentStrategy == Normal_Wraith &&  InfoMan->EnemyBase != BWAPI::TilePositions::Unknown  && Broodwar->getFrameCount() > 4 && workerScouts.size() != 0 ){
		//send scv back
		CCmanager[0]->addSCV( workerScouts[0].scv );
		workerScouts.clear();
	}

	if( CurrentStrategy == BBS &&  InfoMan->EnemyBase != BWAPI::TilePositions::Unknown  && Broodwar->getFrameCount() > 4 && workerScouts.size() != 0 ){
		//send scv back
		CCmanager[0]->addSCV( workerScouts[0].scv );
		CCmanager[0]->addSCV( workerScouts[1].scv );
		workerScouts.clear();
	}
	if( CurrentStrategy == One_Fact_3_Rax &&  InfoMan->EnemyBase != BWAPI::TilePositions::Unknown  && Broodwar->getFrameCount() > 4 && workerScouts.size() != 0 ){
		//send scv back
		//CCmanager[0]->addSCV( workerScouts[0].scv );

		//send to enemy base
		workerScouts[0].scv->move( InfoMan->PosEnemyBase );
		workerScouts.clear();
	}

	if( CurrentStrategy == Wall_in &&  InfoMan->EnemyBase != BWAPI::TilePositions::Unknown  && Broodwar->getFrameCount() > 4 && workerScouts.size() != 0 ){
		//send to enemy base
		workerScouts[0].scv->move( InfoMan->PosEnemyBase );
		//CCmanager[0]->addSCV( workerScouts[0].scv );
		workerScouts.clear();
	}


}