
#include "Common.h"
#include "RepairManager.h"
#include <boost/foreach.hpp>


RepairManager::RepairManager(){


}


void RepairManager::OnFrame(){

	BOOST_FOREACH( Unit* myB, Broodwar->self()->getUnits() ){
		if( !myB->getType().isBuilding() || !myB->isCompleted() ){
			continue;
		}
		if( myB->getHitPoints() < myB->getType().maxHitPoints() ){
          bool exists = false;
	      BOOST_FOREACH(RBuilding rBuild, RB ){
			  if( rBuild.toRepair->getID() == myB->getID() ){
				  exists = true;
				  break;
			  }
	      }
		  //building needs repair
		  if( exists == false ){
			  RBuilding newRB;
			  newRB.toRepair = myB;
			  Unit* getSCV = CCmanager[0]->getBuilder();
			  if(  getSCV != NULL ){
			  newRB.RepairSCVS.push_back( getSCV );
			  }
			  getSCV = CCmanager[0]->getBuilder();
			  if(  getSCV != NULL ){
			  newRB.RepairSCVS.push_back( getSCV );
			  }
			  RB.push_back( newRB );
			  Broodwar->printf("Repair started");
		  }
		}
	}

	for(unsigned int i=0; i<RB.size(); i++){
		if( RB[i].toRepair->getHitPoints() == RB[i].toRepair->getType().maxHitPoints() ){
			for(unsigned int j=0; j<RB[i].RepairSCVS.size(); j++){
				CCmanager[0]->addSCV( RB[i].RepairSCVS[j] );
			}
			RB[i].RepairSCVS.empty();
			RB.erase( RB.begin() + i );
			Broodwar->printf("Repair ended");
			i--;
			continue;
		}
	}
	for(unsigned int i=0; i<RB.size(); i++){
		if( RB[i].toRepair->getHitPoints() != RB[i].toRepair->getType().maxHitPoints() ){
			for(unsigned int j=0; j<RB[i].RepairSCVS.size(); j++){
				if( RB[i].RepairSCVS[j]->getOrder() != BWAPI::Orders::Repair ){
				RB[i].RepairSCVS[j]->repair(  RB[i].toRepair );
				}
				if( !RB[i].RepairSCVS[j]->exists() ){
					RB[i].RepairSCVS.erase( RB[i].RepairSCVS.begin() + j );
					j--;
					continue;
				}
			}
		}
	}

	for(unsigned int i=0; i<RB.size(); i++){
		if( RB[i].toRepair->getHitPoints() != RB[i].toRepair->getType().maxHitPoints() ){
			if(  RB[i].RepairSCVS.size() < 1 ){
				Unit* extraSCV = CCmanager[0]->getBuilder();
				if( extraSCV != NULL ){
				  RB[i].RepairSCVS.push_back( extraSCV );
				}
			}
		}
	}



}

void RepairManager::AddSCV( BWAPI::Unit* scv){

}