#pragma once

#include "Common.h"
#include "BuildingManager.h"

#include <BWAPI.h>
#include <BWTA.h>

using namespace BWAPI;



enum GameState{
	First_Supply,
	First_Barracks,
	First_Gas,
	Second_Supply,
    StarPort,
	Done
};

enum BBState{
	Eight_Workers,
	First_B,
	Second_B,
	Supply_Nine,
	Pump_Marines
};


enum Wall_In_State{
	Initial_build,
	Follow_Up_Zerg,
	Follow_Up_Terran,
	Follow_Up_Protoss,
	Expand
};

enum Deep_Six_State{
	Initial_BO,
	Two_Marines,
	Build_Rax
};

struct BuildQueue{
	Unit* scv;
	UnitType type;
    TilePosition buildLocation;
	Unit* building;
	bool Started;
	int FrameStarted;
};

struct BO{
	UnitType type;
	int supply;
};

class ProductionManager{
public:

	GameState buildingState;
	BBState   bbState;
	Wall_In_State wState;
	Deep_Six_State DSstate;

	int reservedMinerals;
	int reservedGas;

	std::vector<UnitType> BuildingOrder;
	std::vector<BO> BuildingSupplyOrder;
	std::vector< BuildQueue > BuildingsQueue;
	std::vector< BWAPI::TechType > Research;


	ProductionManager();
	void onFrame();
	void onFrameMain();
	void onFrameWorkerRush();
	void onFrameBunkerRush();
	void onFrameBBS();
	void onFrame1Fact3Rax();
	void onFrameDeepSix();
	void onFrameWallIn();
	void checkSCVbuild();
	void onUnitComplete(BWAPI::Unit *unit);
	//Unit* bSCV;

	void addToQueue(BWAPI::UnitType type);
	void addToQueueTile(BWAPI::UnitType type, BWAPI::TilePosition tile);
	void addToQueueClose(BWAPI::UnitType type, BWAPI::TilePosition tile, bool inBase=true);
	void addSupplyBO(BWAPI::UnitType type, int supply);

	int getAvailableMinerals();
	int getAvailableGas();

	//Production buildings
	std::vector<Unit*> CommandCenters;
	std::vector<Unit*> FactoryNoAddon;
	std::vector<Unit*> FactoryShop;
	std::vector<Unit*> StarportNoAddon;
	std::vector<Unit*> StarportCtower;
    std::vector<Unit*> Barracks;
    std::vector<Unit*> Armory;
	Unit* Academy;
	Unit* EngineeringBay;

};