

#include "ProductionManager.h"

#include <boost/foreach.hpp>


ProductionManager::ProductionManager(){

	buildingState = First_Supply;
	bbState = Eight_Workers;
	wState = Initial_build;
	DSstate = Initial_BO;

	reservedMinerals = 0;
	reservedGas = 0;

	BuildingsQueue.clear();
	//bSCV = NULL;
	EngineeringBay = NULL;
	Academy = NULL;


	//Build order for 2 port wraith
	BuildingOrder.push_back( BWAPI::UnitTypes::Terran_Supply_Depot);
	BuildingOrder.push_back( BWAPI::UnitTypes::Terran_Barracks );
	BuildingOrder.push_back( BWAPI::UnitTypes::Terran_Refinery );
	BuildingOrder.push_back( BWAPI::UnitTypes::Terran_Supply_Depot );
	BuildingOrder.push_back( BWAPI::UnitTypes::Terran_Factory );
	BuildingOrder.push_back( BWAPI::UnitTypes::Terran_Starport );
	BuildingOrder.push_back( BWAPI::UnitTypes::Terran_Starport );
	BuildingOrder.push_back( BWAPI::UnitTypes::Terran_Supply_Depot );

	if( CurrentStrategy == Wall_in ){
      BuildingOrder.clear();
	  BuildingOrder.push_back( BWAPI::UnitTypes::Terran_Supply_Depot);
	  BuildingOrder.push_back( BWAPI::UnitTypes::Terran_Barracks );
	  BuildingOrder.push_back( BWAPI::UnitTypes::Terran_Refinery );
	  BuildingOrder.push_back( BWAPI::UnitTypes::Terran_Supply_Depot );
	  BuildingOrder.push_back( BWAPI::UnitTypes::Terran_Factory );
	  /*
	  BuildingOrder.push_back( BWAPI::UnitTypes::Terran_Starport );
	  //2 port
	  if( Broodwar->enemy()->getRace() == BWAPI::Races::Zerg ){
	    BuildingOrder.push_back( BWAPI::UnitTypes::Terran_Starport );
	  } 
	  BuildingOrder.push_back( BWAPI::UnitTypes::Terran_Command_Center );
	  */
	}

	if( CurrentStrategy == One_Fact_3_Rax ) {
	  addSupplyBO( BWAPI::UnitTypes::Terran_Supply_Depot, 9);
	  addSupplyBO( BWAPI::UnitTypes::Terran_Barracks, 11);
	  addSupplyBO( BWAPI::UnitTypes::Terran_Refinery, 12);	
	  addSupplyBO( BWAPI::UnitTypes::Terran_Supply_Depot, 15);
	  addSupplyBO( BWAPI::UnitTypes::Terran_Factory, 16);
	  addSupplyBO( BWAPI::UnitTypes::Terran_Academy, 21);
	  addSupplyBO( BWAPI::UnitTypes::Terran_Supply_Depot, 23);
	}

	if( CurrentStrategy == Deep_six ) {
	  addSupplyBO( BWAPI::UnitTypes::Terran_Supply_Depot, 9);
	  addSupplyBO( BWAPI::UnitTypes::Terran_Barracks, 11);
	  addSupplyBO( BWAPI::UnitTypes::Terran_Command_Center, 15);
	  addSupplyBO( BWAPI::UnitTypes::Terran_Refinery, 16);	
	  addSupplyBO( BWAPI::UnitTypes::Terran_Supply_Depot, 16);
	  addSupplyBO( BWAPI::UnitTypes::Terran_Bunker, 18);
	  addSupplyBO( BWAPI::UnitTypes::Terran_Factory, 20);
	  BuildingOrder.clear();
	}


}


int ProductionManager::getAvailableMinerals(){
	return Broodwar->self()->minerals() - reservedMinerals;
}

int ProductionManager::getAvailableGas(){
	return Broodwar->self()->gas() - reservedGas;
}

void ProductionManager::addSupplyBO(BWAPI::UnitType type, int supply){
	BO newBO;
	newBO.type = type;
	newBO.supply = supply;
	BuildingSupplyOrder.push_back(newBO);

}


void ProductionManager::addToQueue(BWAPI::UnitType type)
{
		reservedMinerals +=  type.mineralPrice();
		reservedGas += type.gasPrice();
		BuildQueue addQueue;
		addQueue.buildLocation = bManager->getBuildLocationBase( CCmanager[0]->CommandCenter->getTilePosition(),type,0);
        //reserve space
		bManager->mapArea( bManager->getBuildRectangle(addQueue.buildLocation, type) , 0,0);
		
		addQueue.type = type;
		addQueue.scv = CCmanager[0]->getBuilder();
		addQueue.building = NULL;
		addQueue.Started = false;
		addQueue.FrameStarted = Broodwar->getFrameCount();
		BuildingsQueue.push_back( addQueue );
		Broodwar->printf("Next building added: %s", type.c_str() );
		//BuildingOrder.erase( BuildingOrder.begin() );

}

void ProductionManager::addToQueueTile(BWAPI::UnitType type, BWAPI::TilePosition tile)
{
		reservedMinerals +=  type.mineralPrice();
		reservedGas += type.gasPrice();
		BuildQueue addQueue;
		addQueue.buildLocation = tile;
        //reserve space
		bManager->mapArea( bManager->getBuildRectangle(addQueue.buildLocation, type) , 0,0);
		
		addQueue.type = type;
		addQueue.scv = CCmanager[0]->getBuilder();
		addQueue.building = NULL;
		addQueue.Started = false;
		addQueue.FrameStarted = Broodwar->getFrameCount();
		BuildingsQueue.push_back( addQueue );
		Broodwar->printf("Next building added: %s", type.c_str() );
		//BuildingOrder.erase( BuildingOrder.begin() );

}


void ProductionManager::addToQueueClose(BWAPI::UnitType type, BWAPI::TilePosition tile, bool inBase)
{
		reservedMinerals +=  type.mineralPrice();
		reservedGas += type.gasPrice();
		BuildQueue addQueue;
		if( inBase ){
		  addQueue.buildLocation = bManager->getBuildLocationBase( tile,type, BWTA::getRegion( InfoMan->PosOurBase ) );
		} else {
		  addQueue.buildLocation = bManager->getBuildLocationBase( tile,type, 0 );
		}
        //reserve space
		bManager->mapArea( bManager->getBuildRectangle(addQueue.buildLocation, type) , 0,0);
		
		addQueue.type = type;
		addQueue.scv = CCmanager[0]->getBuilder();
		addQueue.building = NULL;
		addQueue.Started = false;
		addQueue.FrameStarted = Broodwar->getFrameCount();
		BuildingsQueue.push_back( addQueue );
		Broodwar->printf("Next building added: %s", type.c_str() );
		//BuildingOrder.erase( BuildingOrder.begin() );

}

void ProductionManager::onFrameWorkerRush(){

	if(  (Broodwar->self()->minerals() - reservedMinerals) >= 50 && Broodwar->self()->completedUnitCount( BWAPI::UnitTypes::Terran_SCV) < CCmanager[0]->SCVsaturation ){
		CCmanager[0]->buildSCV();
	}

}


void ProductionManager::checkSCVbuild()
{


	for(unsigned int i=0; i<BuildingsQueue.size(); i++){
		if(  BuildingsQueue[i].scv == NULL || !BuildingsQueue[i].scv->exists() ){
			//Broodwar->printf("No scv assigned. Reassigning");
			BuildingsQueue[i].scv = CCmanager[0]->getBuilder();
			continue;
		}
		BWAPI::Position moveTo = BWAPI::Position( BuildingsQueue[i].buildLocation );

		// start frame not set
		if( BuildingsQueue[i].FrameStarted == 0 ){
			BuildingsQueue[i].FrameStarted = Broodwar->getFrameCount();
		}

		//check if the scv is stuck or otherwise unable to build
		if( Broodwar->getFrameCount() - BuildingsQueue[i].FrameStarted > 3000 ){
			Broodwar->printf("SCV stuck. Reassigning");
			Unit* stuck = BuildingsQueue[i].scv;
			BuildingsQueue[i].scv = CCmanager[0]->getBuilder();
			CCmanager[0]->addSCV( stuck );
			BuildingsQueue[i].FrameStarted = Broodwar->getFrameCount();
			continue;
		}

		/*
		if(  !Broodwar->isVisible( BuildingsQueue[i].buildLocation ) ){
			BuildingsQueue[i].scv->move(moveTo);
		} else {
			BuildingsQueue[i].scv->build( BuildingsQueue[i].buildLocation , BuildingsQueue[i].type );
		}
		*/
		if(  !Broodwar->isVisible( BuildingsQueue[i].buildLocation ) ){
			BuildingsQueue[i].scv->move(moveTo);
		} else if ( Broodwar->isVisible( BuildingsQueue[i].buildLocation ) && BuildingsQueue[i].building == NULL ) {
			BuildingsQueue[i].scv->build( BuildingsQueue[i].buildLocation , BuildingsQueue[i].type );
		} else { //building already placed down
			//if it has been destoyed, rebuild it
			if( !BuildingsQueue[i].building->exists() ) {
			  BuildingsQueue[i].scv->build( BuildingsQueue[i].buildLocation , BuildingsQueue[i].type );
			}
			else if( BuildingsQueue[i].scv->getOrder() != BWAPI::Orders::ConstructingBuilding  ){
				BuildingsQueue[i].scv->rightClick( BuildingsQueue[i].building );
			}
		}

		//The scv is currently building
		if(  BuildingsQueue[i].building == NULL &&  BuildingsQueue[i].scv->getBuildUnit() != NULL  ){
			 BuildingsQueue[i].building =  BuildingsQueue[i].scv->getBuildUnit();
		}
		if(  BuildingsQueue[i].building != NULL){
			if( BuildingsQueue[i].Started == false ){
			  reservedMinerals -= BuildingsQueue[i].type.mineralPrice();
			  reservedGas -= BuildingsQueue[i].type.gasPrice();
			  BuildingsQueue[i].Started = true;
			}
			if(BuildingsQueue[i].building->isCompleted()  ){
			  CCmanager[0]->addSCV(BuildingsQueue[i].scv);
			  //reservedMinerals -= BuildingsQueue[i].type.mineralPrice();
			  //reservedGas -= BuildingsQueue[i].type.gasPrice();

			  /*
			  if(BuildingsQueue[i].type == BWAPI::UnitTypes::Terran_Refinery){
				  Broodwar->printf("Refinery done");
				  CCmanager[0]->Refinerys.push_back(BuildingsQueue[i].building);
		         CCmanager[0]->toGas();
			  }
			  */
			  if(BuildingsQueue[i].type == BWAPI::UnitTypes::Terran_Refinery){
		        int closestCC = 9999;
		        int closeID = 0;
		        for( unsigned int j=0; j<CCmanager.size(); j++ ){
			      if(  CCmanager[j]->CommandCenter->getPosition().getDistance(BuildingsQueue[i].building->getPosition()) < closestCC ){
					closestCC = CCmanager[j]->CommandCenter->getPosition().getDistance(BuildingsQueue[i].building->getPosition());
					closeID = j;
			      }
		        }

		        Broodwar->printf("Refinery done");
				CCmanager[closeID]->Refinerys.push_back( BuildingsQueue[i].building );
		        CCmanager[closeID]->toGas();
			  }

			  BuildingsQueue.erase(  BuildingsQueue.begin() + i );
			  i--;
			  Broodwar->printf("job done");
			}	
		}
	}



}

void ProductionManager::onFrameMain(){

    checkSCVbuild();
	
	if( BuildingOrder.size() > 0 && BuildingOrder[0].mineralPrice() <=  ( Broodwar->self()->minerals() - reservedMinerals) ){
		//Broodwar->printf("adding possible");
	}
	if( BuildingOrder.size() > 0 && BuildingOrder[0].mineralPrice() <=  ( Broodwar->self()->minerals() - reservedMinerals) && BuildingOrder[0].gasPrice() <=  ( Broodwar->self()->gas() - reservedGas )){ // && bManager->WallCalculated
		addToQueue( BuildingOrder[0] );
		BuildingOrder.erase( BuildingOrder.begin() );
	}
	
	//build as many wraiths as possible
	if( StarportNoAddon.size() > 0 || StarportCtower.size() > 0 ){
		bool buildingDepot = false;
		for(unsigned int i=0; i<BuildingsQueue.size(); i++){
			if( BuildingsQueue[i].type == BWAPI::UnitTypes::Terran_Supply_Depot ){
				buildingDepot = true;
			}
		}
		if( (Broodwar->self()->supplyTotal() -  Broodwar->self()->supplyUsed()) < 10 && !buildingDepot ){
		//if( !buildingDepot ){
		  addToQueue( BWAPI::UnitTypes::Terran_Supply_Depot );
		}

		if( StarportNoAddon.size() > 0 && StarportCtower.size() == 0 ){
		  if( StarportNoAddon[0]->getAddon() == NULL){
			StarportNoAddon[0]->buildAddon( BWAPI::UnitTypes::Terran_Control_Tower );
		  }
		  /*
		  if( StarportNoAddon[0]->getAddon() != NULL){
			StarportNoAddon[0]->getAddon()->research( BWAPI::TechTypes::Cloaking_Field);
		  }
		  */
		}

		//train wraith
		for(unsigned int i=0; i<StarportNoAddon.size(); i++){
			if( StarportNoAddon[i]->getTrainingQueue().size() == 0 ){
		     StarportNoAddon[i]->train( BWAPI::UnitTypes::Terran_Wraith);
		  }
		}
		//train wraith
		for(unsigned int i=0; i<StarportCtower.size(); i++){
			if( StarportCtower[i]->getTrainingQueue().size() == 0 ){
		     StarportCtower[i]->train( BWAPI::UnitTypes::Terran_Wraith);
		  }
		}
	}
	
	if(  (Broodwar->self()->minerals() - reservedMinerals) >= 50 && Broodwar->self()->completedUnitCount( BWAPI::UnitTypes::Terran_SCV) < CCmanager[0]->SCVsaturation ){
		CCmanager[0]->buildSCV();
	}

	//time to start training marines
	if(  (Broodwar->self()->minerals() - reservedMinerals) >= 100 ){
		bool trainMore = true;
		if( Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Terran_Factory) == 0 ){
			trainMore = false;
		}
		for(unsigned int i=0; i<Barracks.size(); i++){
		  if( Barracks[i]->getTrainingQueue().size() == 0 && trainMore ){
		    Barracks[i]->train(BWAPI::UnitTypes::Terran_Marine);
		  }
		}
		//if we have to many minerals, build another barracks
		if( StarportNoAddon.size() > 0 &&  (Broodwar->self()->minerals() - reservedMinerals) >= 250 && BuildingsQueue.size() == 0 
			&&  BuildingOrder.size() == 0 && Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Terran_Barracks) < 3 ){
			BuildingOrder.push_back( BWAPI::UnitTypes::Terran_Barracks );
		}
	}

}



void ProductionManager::onFrameWallIn(){

    checkSCVbuild();
	
	if( BuildingOrder.size() > 0 && BuildingOrder[0].mineralPrice() <=  ( Broodwar->self()->minerals() - reservedMinerals) ){
		//Broodwar->printf("adding possible");
	}
	if( BuildingOrder.size() > 0 && BuildingOrder[0].mineralPrice() <=  ( Broodwar->self()->minerals() - reservedMinerals) && BuildingOrder[0].gasPrice() <=  ( Broodwar->self()->gas() - reservedGas )){ // && bManager->WallCalculated
		addToQueue( BuildingOrder[0] );
		BuildingOrder.erase( BuildingOrder.begin() );
	}
	
	//builds scvs
	for(unsigned int j=0; j<CCmanager.size(); j++){
		if(  getAvailableMinerals() >= 50 && CCmanager[j]->MineralSCV.size() < CCmanager[0]->SCVsaturation ){
		CCmanager[j]->buildSCV();
	  }
	}

	//train a marine to defend the wall
	if( Broodwar->getFrameCount() >= 4000 && wState == Initial_build 
		&& Broodwar->self()->completedUnitCount( BWAPI::UnitTypes::Terran_Marine) < 1 ){
		if( Barracks[0]->getTrainingQueue().size() == 0 ){
		  Barracks[0]->train(BWAPI::UnitTypes::Terran_Marine);
		}
	}

	//first factory done, transition from here
	if( wState == Initial_build && FactoryNoAddon.size() > 0 ){
		if(  InfoMan->EnemyRace == BWAPI::Races::Protoss || InfoMan->EnemyRace == BWAPI::Races::Unknown ){
		  wState = Follow_Up_Protoss;
		  //siege expand
		  BuildingOrder.push_back( BWAPI::UnitTypes::Terran_Command_Center );
		  BuildingOrder.push_back( BWAPI::UnitTypes::Terran_Engineering_Bay );
		}
		if(  InfoMan->EnemyRace == BWAPI::Races::Zerg ){
		  wState = Follow_Up_Zerg;
		  //2 port wraith
		  BuildingOrder.push_back( BWAPI::UnitTypes::Terran_Starport );
		  BuildingOrder.push_back( BWAPI::UnitTypes::Terran_Starport );
		  BuildingOrder.push_back( BWAPI::UnitTypes::Terran_Command_Center );
		}
		if(  InfoMan->EnemyRace == BWAPI::Races::Terran ){
		  wState = Follow_Up_Terran;
		  //1 port wraith
		  BuildingOrder.push_back( BWAPI::UnitTypes::Terran_Starport );
		  BuildingOrder.push_back( BWAPI::UnitTypes::Terran_Command_Center );
		}
	}

	//command center done
	if( (wState == Follow_Up_Protoss || wState == Follow_Up_Terran || wState == Follow_Up_Zerg )
		&& Broodwar->self()->completedUnitCount( BWAPI::UnitTypes::Terran_Command_Center ) == 2 ){
      wState = Expand;
	  //two more factories
	  addToQueue( BWAPI::UnitTypes::Terran_Factory);
	  addToQueue( BWAPI::UnitTypes::Terran_Factory);
	  if( EngineeringBay != NULL ){
	    //hold of DT, lurkers and wraiths
	    addToQueue( BWAPI::UnitTypes::Terran_Missile_Turret);
	    //BWAPI::TilePosition( bManager->toDefend->getCenter() )
	    addToQueueClose(BWAPI::UnitTypes::Terran_Missile_Turret, bManager->SupplyWall1 );
	  }
	  CCmanager[0]->SCVsaturation += 18;//needed for maynarding
	}

	//build extra depots if needed
    if( (wState == Follow_Up_Protoss || wState == Follow_Up_Terran || wState == Follow_Up_Zerg ) ){
		bool buildingDepot = false;
		for(unsigned int i=0; i<BuildingsQueue.size(); i++){
			if( BuildingsQueue[i].type == BWAPI::UnitTypes::Terran_Supply_Depot ){
				buildingDepot = true;
			}
		}
		if( (Broodwar->self()->supplyTotal() -  Broodwar->self()->supplyUsed()) < 10 && !buildingDepot ){
		//if( !buildingDepot ){
		  addToQueue( BWAPI::UnitTypes::Terran_Supply_Depot );
		  //addToQueue( BWAPI::UnitTypes::Terran_Supply_Depot );
		}
	}

	if( (wState == Follow_Up_Protoss || wState == Follow_Up_Terran) && FactoryNoAddon.size() > 0 ){
		FactoryNoAddon[0]->buildAddon( BWAPI::UnitTypes::Terran_Machine_Shop );
	}

	if( (wState == Follow_Up_Protoss) && FactoryShop.size() > 0 && !Broodwar->self()->hasResearched( BWAPI::TechTypes::Tank_Siege_Mode ) ){
		FactoryShop[0]->getAddon()->research(BWAPI::TechTypes::Tank_Siege_Mode);
	}

	if( (wState == Follow_Up_Terran) && FactoryShop.size() > 0 && !Broodwar->self()->hasResearched( BWAPI::TechTypes::Spider_Mines ) ){
		FactoryShop[0]->getAddon()->research(BWAPI::TechTypes::Spider_Mines);
	}

	if( (wState == Follow_Up_Protoss) && FactoryShop.size() > 0  ){
		if( FactoryShop[0]->getTrainingQueue().size() == 0 ){
		  FactoryShop[0]->train( BWAPI::UnitTypes::Terran_Siege_Tank_Tank_Mode );
		}
	}

	if( (wState == Follow_Up_Terran) && FactoryShop.size() > 0  ){
		if( FactoryShop[0]->getTrainingQueue().size() == 0 ){
			FactoryShop[0]->train( BWAPI::UnitTypes::Terran_Vulture );
		}
	}

	if( (wState == Follow_Up_Zerg ) && FactoryNoAddon.size() > 0  ){
		if( FactoryNoAddon[0]->getTrainingQueue().size() == 0 ){
			FactoryNoAddon[0]->train( BWAPI::UnitTypes::Terran_Vulture );
		}
	}

	if( (wState == Follow_Up_Zerg || wState == Follow_Up_Terran) && StarportNoAddon.size() > 0  ){
		for(unsigned int j=0; j<StarportNoAddon.size(); j++){
		  if( StarportNoAddon[j]->getTrainingQueue().size() == 0 ){
			StarportNoAddon[j]->train( BWAPI::UnitTypes::Terran_Wraith );
		  }
		}
	}

	//build all that you have
	if( wState == Expand ){

		bool buildingDepot = false;
		for(unsigned int i=0; i<BuildingsQueue.size(); i++){
			if( BuildingsQueue[i].type == BWAPI::UnitTypes::Terran_Supply_Depot ){
				buildingDepot = true;
			}
		}
		if( (Broodwar->self()->supplyTotal() -  Broodwar->self()->supplyUsed()) < 10 && !buildingDepot ){
		//if( !buildingDepot ){
		  addToQueue( BWAPI::UnitTypes::Terran_Supply_Depot );
		  addToQueue( BWAPI::UnitTypes::Terran_Supply_Depot );
		}

		for(unsigned int j=0; j<StarportNoAddon.size(); j++){
		  if( StarportNoAddon[j]->getTrainingQueue().size() == 0 ){
			StarportNoAddon[j]->train( BWAPI::UnitTypes::Terran_Wraith );
		  }
		}
		for(unsigned int j=0; j<FactoryShop.size(); j++){
		  if( FactoryShop[j]->getTrainingQueue().size() == 0 ){
			  FactoryShop[j]->train( BWAPI::UnitTypes::Terran_Siege_Tank_Tank_Mode );
		  }
		}
		for(unsigned int j=0; j<FactoryNoAddon.size(); j++){
		  if( FactoryNoAddon[j]->getTrainingQueue().size() == 0 ){
			  FactoryNoAddon[j]->train( BWAPI::UnitTypes::Terran_Vulture );
		  }
		}

	}

}



void ProductionManager::onFrameBunkerRush(){

	//checkSCVbuild(); //Returns the scv back, so do not use it here


	for(unsigned int i=0; i<BuildingsQueue.size(); i++){
		if(  BuildingsQueue[i].scv == NULL || !BuildingsQueue[i].scv->exists() ){
			Broodwar->printf("No scv assigned. Reassigning");
			if( BRMan == NULL ){
			  BuildingsQueue[i].scv = CCmanager[0]->getBuilder();
			} else {
				BuildingsQueue[i].scv = BRMan->GetBuilder();
			}
			continue;
		}
		BWAPI::Position moveTo = BWAPI::Position( BuildingsQueue[i].buildLocation );

		// start frame not set
		if( BuildingsQueue[i].FrameStarted == 0 ){
			BuildingsQueue[i].FrameStarted = Broodwar->getFrameCount();
		}

		//check if the scv is stuck or otherwise unable to build
		if( Broodwar->getFrameCount() - BuildingsQueue[i].FrameStarted > 3000 ){
			Broodwar->printf("SCV stuck. Reassigning");
			Unit* stuck = BuildingsQueue[i].scv;
			if( BRMan == NULL ){
			  BuildingsQueue[i].scv = CCmanager[0]->getBuilder();
			} else {
				BuildingsQueue[i].scv = BRMan->GetBuilder();
			}
			CCmanager[0]->addSCV( stuck );
			BuildingsQueue[i].FrameStarted = Broodwar->getFrameCount();
			continue;
		}

		/*
		if(  !Broodwar->isVisible( BuildingsQueue[i].buildLocation ) ){
			BuildingsQueue[i].scv->move(moveTo);
		} else {
			BuildingsQueue[i].scv->build( BuildingsQueue[i].buildLocation , BuildingsQueue[i].type );
		}
		*/
		if(  !Broodwar->isVisible( BuildingsQueue[i].buildLocation ) ){
			BuildingsQueue[i].scv->move(moveTo);
		} else if ( Broodwar->isVisible( BuildingsQueue[i].buildLocation ) && BuildingsQueue[i].building == NULL ) {
			BuildingsQueue[i].scv->build( BuildingsQueue[i].buildLocation , BuildingsQueue[i].type );
		} else { //building already placed down
			//if it has been destoyed, rebuild it
			if( !BuildingsQueue[i].building->exists() ) {
			  BuildingsQueue[i].scv->build( BuildingsQueue[i].buildLocation , BuildingsQueue[i].type );
			}
			else if( BuildingsQueue[i].scv->getOrder() != BWAPI::Orders::ConstructingBuilding  ){
				BuildingsQueue[i].scv->rightClick( BuildingsQueue[i].building );
			}
		}

		//The scv is currently building
		if(  BuildingsQueue[i].building == NULL &&  BuildingsQueue[i].scv->getBuildUnit() != NULL  ){
			 BuildingsQueue[i].building =  BuildingsQueue[i].scv->getBuildUnit();
		}
		if(  BuildingsQueue[i].building != NULL){
			if( BuildingsQueue[i].Started == false ){
			  reservedMinerals -= BuildingsQueue[i].type.mineralPrice();
			  reservedGas -= BuildingsQueue[i].type.gasPrice();
			  BuildingsQueue[i].Started = true;
			}
			if(BuildingsQueue[i].building->isCompleted()  ){


			  if(BuildingsQueue[i].type == BWAPI::UnitTypes::Terran_Refinery){
		        int closestCC = 9999;
		        int closeID = 0;
		        for( unsigned int j=0; j<CCmanager.size(); j++ ){
			      if(  CCmanager[j]->CommandCenter->getPosition().getDistance(BuildingsQueue[i].building->getPosition()) < closestCC ){
					closestCC = CCmanager[j]->CommandCenter->getPosition().getDistance(BuildingsQueue[i].building->getPosition());
					closeID = j;
			      }
		        }

		        Broodwar->printf("Refinery done");
				//CCmanager[closeID]->Refinerys.push_back( BuildingsQueue[i].building );
		        //CCmanager[closeID]->toGas();
			  }

			  BuildingsQueue.erase(  BuildingsQueue.begin() + i );
			  i--;
			  Broodwar->printf("job done");
			}	
		}
	}

	//train marines
	if( BRMan != NULL &&  (Broodwar->self()->minerals() - reservedMinerals) >= 50  ){
		if( BRMan->Barracks != NULL ){
		  if( BRMan->Barracks->getTrainingQueue().size() == 0 ){
		    BRMan->Barracks->train(BWAPI::UnitTypes::Terran_Marine);
		  }
		}
		//CCmanager[0]->buildSCV();
	}


	int scvToProduce = 5;
	if( BRMan != NULL ){
		scvToProduce += BRMan->Bunkers.size();
	}

	if(  (Broodwar->self()->minerals() - reservedMinerals) >= 50 && Broodwar->self()->completedUnitCount( BWAPI::UnitTypes::Terran_SCV) < scvToProduce ){
      CCmanager[0]->buildSCV();
	}

}



void ProductionManager::onFrameBBS(){


	for(unsigned int i=0; i<BuildingsQueue.size(); i++){
		if(  BuildingsQueue[i].scv == NULL || !BuildingsQueue[i].scv->exists() ){
			Broodwar->printf("No scv assigned. Reassigning");
			BuildingsQueue[i].scv = CCmanager[0]->getBuilder();
			continue;
		}
		BWAPI::Position moveTo = BWAPI::Position( BuildingsQueue[i].buildLocation );

		/*
		if(  !Broodwar->isVisible( BuildingsQueue[i].buildLocation ) ){
			BuildingsQueue[i].scv->move(moveTo);
		} else {
			BuildingsQueue[i].scv->build( BuildingsQueue[i].buildLocation , BuildingsQueue[i].type );
		}
		*/
		if(  !Broodwar->isVisible( BuildingsQueue[i].buildLocation ) ){
			BuildingsQueue[i].scv->move(moveTo);
		} else if ( Broodwar->isVisible( BuildingsQueue[i].buildLocation ) && BuildingsQueue[i].building == NULL ) {
			BuildingsQueue[i].scv->build( BuildingsQueue[i].buildLocation , BuildingsQueue[i].type );
		} else { //building already placed down
			//if it has been destoyed, rebuild it
			if( !BuildingsQueue[i].building->exists() ) {
			  BuildingsQueue[i].scv->build( BuildingsQueue[i].buildLocation , BuildingsQueue[i].type );
			}
			else if( BuildingsQueue[i].scv->getOrder() != BWAPI::Orders::ConstructingBuilding  ){
				BuildingsQueue[i].scv->rightClick( BuildingsQueue[i].building );
			}
		}

		//The scv is currently building
		if(  BuildingsQueue[i].building == NULL &&  BuildingsQueue[i].scv->getBuildUnit() != NULL  ){
			 BuildingsQueue[i].building =  BuildingsQueue[i].scv->getBuildUnit();
		}
		if(  BuildingsQueue[i].building != NULL) {
			if( BuildingsQueue[i].Started == false ){
			  reservedMinerals -= BuildingsQueue[i].type.mineralPrice();
			  reservedGas -= BuildingsQueue[i].type.gasPrice();
			  BuildingsQueue[i].Started = true;
			}
			if(BuildingsQueue[i].building->isCompleted()  ){
			  CCmanager[0]->addSCV(BuildingsQueue[i].scv);
			  //reservedMinerals -= BuildingsQueue[i].type.mineralPrice();
			  //reservedGas -= BuildingsQueue[i].type.gasPrice();

			  if(BuildingsQueue[i].type == BWAPI::UnitTypes::Terran_Refinery){
				  Broodwar->printf("Refinery done");
				  CCmanager[0]->Refinerys.push_back(BuildingsQueue[i].building);
		         CCmanager[0]->toGas();
			  }

			  //scout after barracks is complete
			  if( BuildingsQueue[i].type == BWAPI::UnitTypes::Terran_Barracks && ScoutMan == NULL ){
                ScoutMan = new ScoutManager(2);
			  }

			  BuildingsQueue.erase(  BuildingsQueue.begin() + i );
			  i--;
			  Broodwar->printf("job done");
			}	
		}
	}



	if( bbState == Eight_Workers && Broodwar->self()->completedUnitCount( BWAPI::UnitTypes::Terran_SCV) == 8 ){
      bbState = First_B;
	}


	if( bbState == Eight_Workers && Broodwar->self()->completedUnitCount( BWAPI::UnitTypes::Terran_SCV) != 8 ){
      CCmanager[0]->buildSCV();
	}

	BWAPI::UnitType Bar = BWAPI::UnitTypes::Terran_Barracks;

	if( bbState == First_B && Bar.mineralPrice() <=  ( Broodwar->self()->minerals() - reservedMinerals) ){ // && bManager->WallCalculated
		addToQueue( BWAPI::UnitTypes::Terran_Barracks );
		bbState = Second_B;
	}

	if( bbState == Second_B && Bar.mineralPrice() <=  ( Broodwar->self()->minerals() - reservedMinerals) ){ // && bManager->WallCalculated
		addToQueue( BWAPI::UnitTypes::Terran_Barracks );
		bbState = Supply_Nine;
	}

	if( bbState == Supply_Nine && Broodwar->self()->completedUnitCount( BWAPI::UnitTypes::Terran_SCV) != 9 ){
      CCmanager[0]->buildSCV();
	}

	BWAPI::UnitType Sup = BWAPI::UnitTypes::Terran_Supply_Depot;
	if( bbState == Supply_Nine && Sup.mineralPrice() <=  ( Broodwar->self()->minerals() - reservedMinerals) ){ // && bManager->WallCalculated
		addToQueue( BWAPI::UnitTypes::Terran_Supply_Depot );
		bbState = Pump_Marines;
	}

	if( bbState == Pump_Marines){
		bool buildingDepot = false;
		for(unsigned int i=0; i<BuildingsQueue.size(); i++){
			if( BuildingsQueue[i].type == BWAPI::UnitTypes::Terran_Supply_Depot ){
				buildingDepot = true;
			}
		}
		if( (Broodwar->self()->supplyTotal() -  Broodwar->self()->supplyUsed()) < 10 && !buildingDepot ){
		//if( !buildingDepot ){
		  addToQueue( BWAPI::UnitTypes::Terran_Supply_Depot );
		}

		//build an extra barracks if there are enough minerals
		if(  ( Broodwar->self()->minerals() - reservedMinerals) > 250 ){
		  addToQueue( BWAPI::UnitTypes::Terran_Barracks );
		}

		for(unsigned int i=0; i<Barracks.size(); i++){
		  if( Barracks[i]->getTrainingQueue().size() == 0 ){
		    Barracks[i]->train(BWAPI::UnitTypes::Terran_Marine);
		  }
		}

	}

}


void ProductionManager::onFrame1Fact3Rax(){


	checkSCVbuild();

	if( BuildingSupplyOrder.size() > 0 && BuildingSupplyOrder[0].supply <=  Broodwar->self()->supplyUsed()/2 ){ // && bManager->WallCalculated
		addToQueue( BuildingSupplyOrder[0].type );
		BuildingSupplyOrder.erase( BuildingSupplyOrder.begin() );
	}

	if( BuildingSupplyOrder.size() == 0 ){ // && bManager->WallCalculated
		bool buildingDepot = false;
		for(unsigned int i=0; i<BuildingsQueue.size(); i++){
			if( BuildingsQueue[i].type == BWAPI::UnitTypes::Terran_Supply_Depot ){
				buildingDepot = true;
			}
		}
		if( (Broodwar->self()->supplyTotal() -  Broodwar->self()->supplyUsed()) < 10 && !buildingDepot ){
		//if( !buildingDepot ){
		  addToQueue( BWAPI::UnitTypes::Terran_Supply_Depot );
		}
		bool buildingBarracks = false;
		for(unsigned int i=0; i<BuildingsQueue.size(); i++){
			if( BuildingsQueue[i].type == BWAPI::UnitTypes::Terran_Barracks ){
				buildingBarracks = true;
			}
		}
		//build an extra barracks if there are enough minerals
		if(  Broodwar->self()->completedUnitCount( BWAPI::UnitTypes::Terran_Barracks ) < 3 &&  !buildingBarracks && ( Broodwar->self()->minerals() - reservedMinerals) > 250 ){
		  addToQueue( BWAPI::UnitTypes::Terran_Barracks );
		}
	}

	if( StarportNoAddon.size() > 0){
		if( StarportNoAddon[0]->getTrainingQueue().size() == 0  ){
			StarportNoAddon[0]->train( BWAPI::UnitTypes::Terran_Wraith );
		}
	}

	if( FactoryNoAddon.size() > 0){
		FactoryNoAddon[0]->buildAddon( BWAPI::UnitTypes::Terran_Machine_Shop );
	}

	//continous tank production
	if( FactoryShop.size() > 0 ){
		if( FactoryShop[0]->getTrainingQueue().size() == 0  ){
			FactoryShop[0]->train( BWAPI::UnitTypes::Terran_Siege_Tank_Tank_Mode);
		}
		if( !Broodwar->self()->hasResearched( BWAPI::TechTypes::Tank_Siege_Mode ) ){
			FactoryShop[0]->getAddon()->research( BWAPI::TechTypes::Tank_Siege_Mode );
		}
	}

	//stim packs first
	if( Academy != NULL && !Broodwar->self()->hasResearched( BWAPI::TechTypes::Stim_Packs) ){
			Academy->research(  BWAPI::TechTypes::Stim_Packs );
	}

	//then range upgrade
	if( Academy != NULL && Broodwar->self()->getUpgradeLevel( BWAPI::UpgradeTypes::U_238_Shells) == 0
		&& Broodwar->self()->hasResearched( BWAPI::TechTypes::Stim_Packs)  ){
		Academy->upgrade( BWAPI::UpgradeTypes::U_238_Shells);
	}


	for(unsigned int i=0; i<Barracks.size(); i++){

		if( i == 0 && (GMan->stillLifting == true || GMan->BarracksLift == true )  ){
			if( Barracks[i]->getTrainingQueue().size() != 0){
			Barracks[i]->cancelTrain();
			}
			continue;
		}

		if( Barracks[i]->getTrainingQueue().size() == 0 && (Broodwar->self()->minerals() - reservedMinerals) >= 50  ){
		  //Barracks[i]->train(BWAPI::UnitTypes::Terran_Marine);
			bool waitTank = false;
			if( FactoryShop.size() > 0 && 
				(Broodwar->self()->completedUnitCount( BWAPI::UnitTypes::Terran_Siege_Tank_Tank_Mode ) == 0 &&
				Broodwar->self()->completedUnitCount( BWAPI::UnitTypes::Terran_Siege_Tank_Siege_Mode) == 0 ) ){
					if( FactoryShop[0]->getTrainingQueue().size() == 0 ){
					 waitTank = true;
					}
			}
			if(  waitTank == false ){
			  Barracks[i]->train( BioMan->nextUnitBO() );
			}
		}

	}

	if(  (Broodwar->self()->minerals() - reservedMinerals) >= 50 && Broodwar->self()->completedUnitCount( BWAPI::UnitTypes::Terran_SCV) < CCmanager[0]->SCVsaturation ){
		CCmanager[0]->buildSCV();
	}

}



void ProductionManager::onFrameDeepSix(){

    checkSCVbuild();

	if( BuildingSupplyOrder.size() > 0 && BuildingSupplyOrder[0].supply <=  Broodwar->self()->supplyUsed()/2 ){ // && bManager->WallCalculated
		if(  BuildingSupplyOrder[0].type != BWAPI::UnitTypes::Terran_Command_Center
			&& BuildingSupplyOrder[0].type != BWAPI::UnitTypes::Terran_Bunker ){
		  addToQueue( BuildingSupplyOrder[0].type );
		  BuildingSupplyOrder.erase( BuildingSupplyOrder.begin() );
		} else if( BuildingSupplyOrder[0].type == BWAPI::UnitTypes::Terran_Command_Center ){
			DSstate = Two_Marines;
			addToQueueTile( BuildingSupplyOrder[0].type, InfoMan->OurNat );
		    BuildingSupplyOrder.erase( BuildingSupplyOrder.begin() );
		}  else if( BuildingSupplyOrder[0].type == BWAPI::UnitTypes::Terran_Bunker ){

			//calculate position for the bunker
			BWTA::Chokepoint* natChoke = NULL;
			BWTA::Region* NatReg = BWTA::getRegion( InfoMan->PosOurNat );
			BWTA::Region* HomeReg = BWTA::getRegion( InfoMan->PosOurBase );
			BOOST_FOREACH( BWTA::Chokepoint* choke, NatReg->getChokepoints() )
             {
				 if( choke->getRegions().first != HomeReg && choke->getRegions().second != HomeReg ){
					 natChoke = choke;
					 break;
				 }
			 }
			if( natChoke != NULL ){
			  BWAPI::TilePosition toBuild = BWAPI::TilePosition( natChoke->getCenter() );
			  addToQueueClose( BuildingSupplyOrder[0].type, toBuild, false );
		      BuildingSupplyOrder.erase( BuildingSupplyOrder.begin() );
			}
		}


	}


	if( BuildingOrder.size() > 0 && BuildingOrder[0].mineralPrice() <=  getAvailableMinerals() && BuildingOrder[0].gasPrice() <=  getAvailableGas() ){ // && bManager->WallCalculated
		addToQueue( BuildingOrder[0] );
		BuildingOrder.erase( BuildingOrder.begin() );
	}

	if( DSstate ==  Build_Rax ){

		bool buildingDepot = false;
		for(unsigned int i=0; i<BuildingsQueue.size(); i++){
			if( BuildingsQueue[i].type == BWAPI::UnitTypes::Terran_Supply_Depot ){
				buildingDepot = true;
			}
		}
		if( (Broodwar->self()->supplyTotal() -  Broodwar->self()->supplyUsed()) < 10 && !buildingDepot ){
		//if( !buildingDepot ){
		  addToQueue( BWAPI::UnitTypes::Terran_Supply_Depot );
		}
	}

	if( BuildingSupplyOrder.size() == 0 && DSstate == Two_Marines  ){ // && bManager->WallCalculated
		DSstate =  Build_Rax;
		BuildingOrder.push_back( BWAPI::UnitTypes::Terran_Factory );
		BuildingOrder.push_back( BWAPI::UnitTypes::Terran_Engineering_Bay );
		BuildingOrder.push_back( BWAPI::UnitTypes::Terran_Academy );
		BuildingOrder.push_back( BWAPI::UnitTypes::Terran_Barracks );
		BuildingOrder.push_back( BWAPI::UnitTypes::Terran_Barracks );
		BuildingOrder.push_back( BWAPI::UnitTypes::Terran_Barracks );
		BuildingOrder.push_back( BWAPI::UnitTypes::Terran_Barracks );
		BuildingOrder.push_back( BWAPI::UnitTypes::Terran_Barracks );
	}

	if( DSstate == Two_Marines && Broodwar->self()->completedUnitCount( BWAPI::UnitTypes::Terran_Marine ) < 2
		&& Barracks.size() > 0 && getAvailableMinerals() > 50 ){
		if( Barracks[0]->getTrainingQueue().size() == 0 ){
			//Broodwar->printf( "minerals available:%d", getAvailableMinerals() );
			Barracks[0]->train( BWAPI::UnitTypes::Terran_Marine );
		}
	}

	for(unsigned int i=0; i<FactoryNoAddon.size() ; i++){
		FactoryNoAddon[i]->buildAddon( BWAPI::UnitTypes::Terran_Machine_Shop);
	}


	if( EngineeringBay != NULL && Broodwar->self()->getUpgradeLevel( BWAPI::UpgradeTypes::Terran_Infantry_Armor) == 0  ){
		EngineeringBay->upgrade( BWAPI::UpgradeTypes::Terran_Infantry_Armor );
	}

	if( Academy != NULL && Broodwar->self()->getUpgradeLevel( BWAPI::UpgradeTypes::U_238_Shells) == 0  ){
		Academy->upgrade( BWAPI::UpgradeTypes::U_238_Shells);
	}

	if( Academy != NULL && !Broodwar->self()->hasResearched( BWAPI::TechTypes::Stim_Packs)
		&& Broodwar->self()->getUpgradeLevel( BWAPI::UpgradeTypes::U_238_Shells) == 1 ){
			Academy->research(  BWAPI::TechTypes::Stim_Packs );
	}

	//constant tank production
	for(unsigned int i=0; i<FactoryShop.size() ; i++){
		if( FactoryShop[i]->getTrainingQueue().size() == 0 ){
		  FactoryShop[i]->train( BWAPI::UnitTypes::Terran_Siege_Tank_Tank_Mode );
		}
	}


	if( DSstate ==  Build_Rax ){
		for(unsigned int i=0; i<Barracks.size() ; i++){
		if( Barracks[i]->getTrainingQueue().size() == 0 ){
			if( i % 2 == 0 ){
				Barracks[i]->train( BWAPI::UnitTypes::Terran_Medic );
			} else {
				Barracks[i]->train( BWAPI::UnitTypes::Terran_Marine );
			}
		}
	  }
	}

	//builds scvs
	for(unsigned int j=0; j<CCmanager.size(); j++){
		if(  getAvailableMinerals() >= 50 && CCmanager[j]->MineralSCV.size() < CCmanager[0]->SCVsaturation ){
		CCmanager[j]->buildSCV();
	  }
	}

}

void ProductionManager::onFrame(){


	Broodwar->drawTextScreen(300,60,"Reserved minerals:%d",reservedMinerals);
	Broodwar->drawTextScreen(300,70,"Reserved gas:%d",reservedGas);

	if( CurrentStrategy == Normal_Wraith ){
		onFrameMain();
	}
	if(  CurrentStrategy ==  Worker_Rush  ){
		onFrameWorkerRush();
	}
	if( CurrentStrategy == Bunker_Rush || CurrentStrategy == Bunker_Rush_Two || CurrentStrategy == Gas_Steal  ){
		onFrameBunkerRush();
	}
	if( CurrentStrategy == BBS){
		onFrameBBS();
	}
	if( CurrentStrategy == One_Fact_3_Rax){
		onFrame1Fact3Rax();
	}
	if( CurrentStrategy == Wall_in ){
		onFrameWallIn();
	}
	if( CurrentStrategy == Deep_six ){
		onFrameDeepSix();
	}


}

void ProductionManager::onUnitComplete(BWAPI::Unit *unit){

	if( unit->getPlayer() == Broodwar->enemy() ){
		return;
	}

	if( CurrentStrategy ==  One_Fact_3_Rax
		&& Broodwar->self()->completedUnitCount( BWAPI::UnitTypes::Terran_Supply_Depot ) == 2 ){
			if( GMan->alreadySupply != true ){
		     GMan->BarracksLift = true;
		     GMan->alreadySupply = true;
			}
	}

	/*
	if( unit->getType().isBuilding() ){
		reservedMinerals -= unit->getType().mineralPrice();
		reservedGas -= unit->getType().gasPrice();
	}
	*/


	/*
	if( unit->getType() == BWAPI::UnitTypes::Terran_Refinery ){
		Broodwar->printf("Refinery done");
		CCmanager[0]->Refinerys.push_back(unit);
		CCmanager[0]->toGas();
	}
	*/

	/*
	if( unit->getType() == BWAPI::UnitTypes::Terran_Refinery ){

		int closestCC = 999;
		int closeID = 0;
		for( unsigned int j=0; j<CCmanager.size(); j++ ){
			if(  CCmanager[j]->CommandCenter->getPosition().getDistance(unit->getPosition()) < closestCC ){
					closestCC = CCmanager[j]->CommandCenter->getPosition().getDistance(unit->getPosition());
					closeID = j;
			}
		}

		Broodwar->printf("Refinery done");
		CCmanager[closeID]->Refinerys.push_back( unit );
		CCmanager[closeID]->toGas();

	}
	*/

	if( unit->getType() == BWAPI::UnitTypes::Terran_Command_Center ){
		bool alreadyExists = false;
	    for( unsigned int i=0; i<CCmanager.size(); i++ ){
		  //no double entry
		  if( CCmanager[i]->CommandCenter->getID() == unit->getID() ){
			alreadyExists = true;
		  }
	    }
		if( !alreadyExists ){
		  //float the first one
		  if( Broodwar->self()->completedUnitCount(  BWAPI::UnitTypes::Terran_Command_Center ) == 2 ){
			BaseManager* newBase = new BaseManager( unit, InfoMan->OurNat );
		    CCmanager.push_back( newBase );
		  } else {
		    BaseManager* newBase = new BaseManager( unit, unit->getTilePosition() );
		    CCmanager.push_back( newBase );
		  }
		}

	}

	if( unit->getType() == BWAPI::UnitTypes::Terran_Engineering_Bay ){
		Broodwar->printf("Added engineering bay");
		EngineeringBay = unit;
		FBMan->sendTo(  InfoMan->PosOurNat );
	}

	if( unit->getType() == BWAPI::UnitTypes::Terran_Starport ){
		Broodwar->printf("Added starport");
		StarportNoAddon.push_back(unit);
	}

	if( unit->getType() == BWAPI::UnitTypes::Terran_Control_Tower ){
		Broodwar->printf("Control tower done");
		for(unsigned int i=0; i<StarportNoAddon.size(); i++){
			if(  StarportNoAddon[i]->getAddon() != NULL ){
				StarportCtower.push_back( StarportNoAddon[i] );
				StarportNoAddon.erase( StarportNoAddon.begin() + i );
				break;
			}
		}
	}

	if( unit->getType() == BWAPI::UnitTypes::Terran_Factory ){
		FactoryNoAddon.push_back(unit);
	}

	if( unit->getType() == BWAPI::UnitTypes::Terran_Machine_Shop ){
		for(unsigned int i=0; i<FactoryNoAddon.size(); i++){
			if(  FactoryNoAddon[i]->getAddon() != NULL ){
				FactoryShop.push_back( FactoryNoAddon[i] );
				FactoryNoAddon.erase( FactoryNoAddon.begin() + i );
				break;
			}
		}
	}

	if( unit->getType() == BWAPI::UnitTypes::Terran_Barracks ){
		Barracks.push_back(unit);
		if( CurrentStrategy == Wall_in 
			&& Broodwar->self()->completedUnitCount( BWAPI::UnitTypes::Terran_Barracks ) == 1 ){
		   GMan->BarracksLift = true;
		}
	}

	if( unit->getType() == BWAPI::UnitTypes::Terran_Academy ){
		Academy = unit;
		/*
		if( CurrentStrategy == Bio_8_Rax ){
		CCmanager[0]->toGas(2);//put two more on gas
		}
		*/
	}

	if (unit->getType().isWorker()){
		bool alreadyAssigned = false;
		if( ScoutMan != NULL ){
		  for(unsigned int i=0; i<ScoutMan->workerScouts.size(); i++ ){
			if( ScoutMan->workerScouts[i].scv->getID() == unit->getID() ){
				alreadyAssigned = true;
			  }
		  }
		}
		for(unsigned int j=0; j<ProdMan->BuildingsQueue.size(); j++){
			if( ProdMan->BuildingsQueue[j].scv != NULL ){
				if( ProdMan->BuildingsQueue[j].scv->getID() == unit->getID() ){
				  alreadyAssigned = true;
			  }
			}
		}
		if( !alreadyAssigned ){
			//find the command center that this unit belongs to
			int closestCC = 999;
			int closeID = 0;
			for( unsigned int j=0; j<CCmanager.size(); j++ ){
				if(  CCmanager[j]->CommandCenter->getPosition().getDistance(unit->getPosition()) < closestCC ){
					closestCC = CCmanager[j]->CommandCenter->getPosition().getDistance(unit->getPosition());
					closeID = j;
				}
			}
		  CCmanager[closeID]->addSCV( unit );
		}

	}

}