#include "MarineManager.h"
#include "Common.h"

#include <BWAPI.h>
#include <BWTA.h>
#include <math.h>
#include <algorithm>
#include <boost/foreach.hpp>


MarineManager::MarineManager()
{
	NextAttack = 12; //first attack starts at 12 marines
	currentlyAttacking = NULL;


	for(int x=0; x<128; x++){
	  for(int y=0; y<128; y++){
         MMap[x][y] = 0;
		 StaticMMap[x][y] = 0;
		 if( bManager->WalkMap[x][y] == false ){
			 StaticMMap[x][y] = -900;//unwalkable
		 }
	  }
	}


}

void MarineManager::OnFrame()
{

	//Broodwar->drawTextScreen(300,40,"Next attack: %d",NextAttack);


	for(unsigned int i=0; i<Marines.size(); i++){
		//remove dead marines
		if( !Marines[i].marine->exists() ){
			Marines.erase(Marines.begin() + i );
			i--;
			continue;
		}
	}



	for(unsigned int i=0; i<Marines.size(); i++){
		//Broodwar->printf("%s",Marines[i]->getOrder().c_str() );
		
		std::set<Unit*> EnemyClose = Marines[i].marine->getUnitsInRadius( 8*32 );
		Unit* closest = NULL;
		int closeDist = 9999999;
		BOOST_FOREACH( Unit* close, EnemyClose )
        {
			if(  close->getType().isBuilding() ){
				continue;
			}
			if( close->getPlayer() == Broodwar->enemy() && closeDist > Marines[i].marine->getDistance( close->getPosition() )  ){
				closeDist = Marines[i].marine->getDistance( close->getPosition() );
				closest = close;
			}
		}
		//if there are no enemies nearby, attack;
		if( closest == NULL || ( Marines[i].state == M_Fleeing && closeDist > 2*32 )  ){ //|| closeDist > 3*32
			if( InfoMan->EnemyBase != BWAPI::TilePositions::Unknown ){
				BWAPI::Position attackPos = BWAPI::Position( InfoMan->EnemyBase ); 
				if( Marines[i].marine->getPosition().getDistance( attackPos ) > 6*32 ){
			      Marines[i].state = M_Attacking;
			      //BWAPI::Position attackPos = BWAPI::Position( InfoMan->EnemyBase );
		          Marines[i].marine->attack(  attackPos );
				}
			}
			continue;
		}
		int myRange = 4*32; //attack range of a marine

		bool kite = true;

	  double	minDist = 64;
	  double	dist = closeDist;
	  double	speed = Marines[i].marine->getType().topSpeed();

	  double	timeToEnter = std::max(0.0,(dist - myRange) / speed);
	  if ((timeToEnter >= Marines[i].marine->getGroundWeaponCooldown()) && (dist >= minDist))
	  {
		kite = false;
	  }


	  if (Marines[i].marine->isSelected())
	  {
		  BWAPI::Broodwar->drawCircleMap(Marines[i].marine->getPosition().x(), Marines[i].marine->getPosition().y(), 
	      (int)myRange, BWAPI::Colors::Cyan);
	  }

	  // if we can't shoot, run away  if(kite)
	  if ( closeDist < 2*32)
	  {
		//BWAPI::Position fleePosition(Marines[i].marine->getPosition() - closest->getPosition() + Marines[i].marine->getPosition());
		  BWAPI::Position fleePosition( InfoMan->PosOurBase );
        

		  /*
		BWAPI::Position fleeVector(Marines[i].marine->getPosition() - closest->getPosition() );

		for(int angle = 30; angle < 360; angle += 10){
		  double2 fleeV( fleeVector.x(), fleeVector.y() );
		  fleeV.rotate( angle ); //rotate 30 degrees to come back around
		  BWAPI::Position fleeAdd( fleeV.x, fleeV.y );
		  fleePosition= BWAPI::Position(Marines[i].marine->getPosition() + fleeAdd);
		  BWAPI::TilePosition fleePos =  BWAPI::TilePosition(fleePosition);
		  if( bManager->WalkMap[ fleePos.x() ][ fleePos.y() ] == true ){
			  break;
		  }
		}
		//BWAPI::Position fleePosition(Marines[i].marine->getPosition() + fleeAdd);

		//int deltaX[8] = {0,1,1,1,0,-1,-1,-1};
		//int deltaY[8] = {1,1,0,-1,-1,-1,0,1};

		int marX = Marines[i].marine->getPosition().x() / 32;
		int marY = Marines[i].marine->getPosition().y() / 32;
		*/

		BWAPI::Broodwar->drawLineMap(Marines[i].marine->getPosition().x(), Marines[i].marine->getPosition().y(), 
			fleePosition.x(), fleePosition.y(), BWAPI::Colors::Cyan);
		
		//prevent spam
		if( Marines[i].state !=  M_Fleeing ){
		  Marines[i].marine->move( fleePosition );
		}
		Marines[i].state = M_Fleeing;
	  }
	  


		//check if marine is idle
		if( Marines[i].marine->getOrder() == BWAPI::Orders::PlayerGuard || Marines[i].marine->getOrder() == BWAPI::Orders::None
			|| Marines[i].marine->getOrder() == BWAPI::Orders::Nothing ){
			if( InfoMan->EnemyBase != BWAPI::TilePositions::Unknown ){
				BWAPI::Position attackPos = BWAPI::Position( InfoMan->EnemyBase ); 
				//dont attack when already to close
				if( Marines[i].marine->getPosition().getDistance( attackPos ) > 6*32 ){
			      Marines[i].state = M_Attacking;
			      //BWAPI::Position attackPos = BWAPI::Position( InfoMan->EnemyBase );
		          Marines[i].marine->attack(  attackPos );
				}
			}
		}

	}


	


}

void MarineManager::AddMarine( Unit* unit)
{
	if( unit->getType() == BWAPI::UnitTypes::Terran_Marine ){
		Marine newMarine;
		newMarine.marine = unit;
		newMarine.state = M_Idle;
		if( InfoMan->EnemyBase != BWAPI::TilePositions::Unknown ){
			  newMarine.state = M_Attacking;
			  BWAPI::Position attackPos = BWAPI::Position( InfoMan->EnemyBase );
		      newMarine.marine->attack(  attackPos );
		} else {
          //move to the middle of the map
			if( bManager->WalkMap[ (bManager->mapW/2) ][ (bManager->mapH/2) ] == true ){
			  BWAPI::Position middle( (bManager->mapW/2)*32, (bManager->mapH/2)*32 );
		      newMarine.marine->attack(  middle );
			}
		}
	    Marines.push_back( newMarine );
	  //NextAttack--;
	}
}