#pragma once

#include "Common.h"
#include "InitialDefenceManager.h"

#include <boost/foreach.hpp>


InitialDefenceManager::InitialDefenceManager(){
	canExpand = false;
	stopDefence = false;
}

void InitialDefenceManager::OnFrame(){

	if( !canExpand ){
	  for( unsigned int i=0; i<DFunits.size() ; i++ ){
		BWAPI::Position toMove = BWAPI::Position( bManager->SupplyWall1 );
		//place tank 3 tiles away
		if( DFunits[i]->getPosition().getDistance( toMove ) > 4*32 ){
			DFunits[i]->move( toMove );
			continue;
		}
		//siege up if in position
		if( DFunits[i]->getPosition().getDistance( toMove ) <= 4*32 
			&& DFunits[i]->getType() == BWAPI::UnitTypes::Terran_Siege_Tank_Tank_Mode ){
			DFunits[i]->stop();
			DFunits[i]->useTech( BWAPI::TechTypes::Tank_Siege_Mode );
			continue;
		}

	  }
	}

	/*
	if( canExpand ){
		//extra check
		if( natChoke == NULL ){
			return;
		}
	  for( unsigned int i=0; i<DFunits.size() ; i++ ){
		  BWAPI::Position toMove =  natChoke->getCenter();
		//return to mobile tank to engage
		  if(  DFunits[i]->getType() == BWAPI::UnitTypes::Terran_Siege_Tank_Siege_Mode ){
			DFunits[i]->useTech( BWAPI::TechTypes::Tank_Siege_Mode );
			continue;
		}
		//place tank 4 tiles away
		if( DFunits[i]->getPosition().getDistance( toMove ) > 4*32 && !DFunits[i]->isAttacking() ){
			DFunits[i]->attack( toMove );
			continue;
		}

	  }
	  

	  for( unsigned int i=0; i<Vultures.size() ; i++ ){
		  BWAPI::Position toMove =  natChoke->getCenter();
		//place tank 3 tiles away
		  if( Vultures[i]->getPosition().getDistance( toMove ) > 4*32 && !Vultures[i]->isAttacking() ){
			Vultures[i]->attack( toMove );
			continue;
		}

	  }

	}
	*/

	//check if it is safe to expand
	if( !canExpand && Broodwar->getFrameCount() > 7500 ){

		int myCount = DFunits.size() + Vultures.size();
		int enemyCount = 0;
		BOOST_FOREACH( Unit* enemy, Broodwar->enemy()->getUnits() )
        {
			if( BWTA::getRegion( enemy->getPosition() ) ==  BWTA::getRegion( InfoMan->PosOurNat ) ){
			  enemyCount++;
			}
		}
		if( myCount  > enemyCount && myCount > 6 ){
			canExpand = true;
			stopDefence = true;
			ProdMan->Barracks[0]->lift();
			BWTA::Region* NatReg = BWTA::getRegion( InfoMan->PosOurNat );
			BWTA::Region* HomeReg = BWTA::getRegion( InfoMan->PosOurBase );
			BOOST_FOREACH( BWTA::Chokepoint* choke, NatReg->getChokepoints() )
             {
				 if( choke->getRegions().first != HomeReg && choke->getRegions().second != HomeReg ){
					 natChoke = choke;
					 break;
				 }
			 }

		  //remove initial defence
		  IDMan->stopDefence = true;
		  BOOST_FOREACH( Unit* unit, IDMan->DFunits ){
			AMan->AddUnit(unit);
		  }
		  BOOST_FOREACH( Unit* unit, IDMan->Vultures ){
			AMan->AddUnit(unit);
		  }
		  IDMan->DFunits.clear();
		  IDMan->Vultures.clear();

		}

		/*
		BOOST_FOREACH( Unit* enemy, Broodwar->enemy()->getUnits() )
        {

		}
		*/

	}

}

void InitialDefenceManager::addUnit( Unit* unit ){
	if( stopDefence == true){
		return;
	}
	if( unit->getType() == BWAPI::UnitTypes::Terran_Siege_Tank_Tank_Mode){
	  DFunits.push_back(  unit );
	}
	if( unit->getType() == BWAPI::UnitTypes::Terran_Vulture ){
		Vultures.push_back( unit );
	}

}