#pragma once

#include "Common.h"
#include "BWTA.h"

struct BaseInfo;
typedef std::vector<BaseInfo> BaseInfoVector;

struct BuildingInfo{
	BWAPI::Unit * building;
	BWAPI::Position position;
};

class InformationManager {
	public:

	InformationManager();

	//location of bases;
	BWAPI::TilePosition				OurBase;
	BWAPI::Position				    PosOurBase;
	BWAPI::TilePosition				OurNat;
	BWAPI::Position				    PosOurNat;
	BWAPI::TilePosition	 			EnemyBase;
	BWAPI::Position	 			    PosEnemyBase;
	BWAPI::TilePosition	 			EnemyNatural;

	BWAPI::Race  EnemyRace;

	std::vector<BWAPI::TilePosition>   PossibleBase;

	std::vector<BuildingInfo>  EnemyBuildings;
	std::vector<Unit*>  Sunkens;
    int TotalSunken;

	void setLocationEnemyBase( BWAPI::TilePosition Here );
	void NoBaseHere( BWAPI::TilePosition notHere);
    void GetNaturalEnemy();
	void onUnitShow(BWAPI::Unit * unit);
	void onUnitDestroy(BWAPI::Unit * unit);

	//all gas geyser locations
	std::vector<Unit*>   Minerals;
	std::vector<Unit*>   Geysers;
	std::vector<BWAPI::TilePosition>   GeyserLocations;

};


