#include "GeneralManager.h"

#include "Common.h"

#include <boost/foreach.hpp>

GeneralManager::GeneralManager(){

	BarracksLift = false;
	putBdown = false;
	stillLifting = false;
	onlyOnce = false;
	alreadySupply = false;
}

void GeneralManager::GateManage()
{


	if(  BarracksLift == true ){
		BarracksLift = false;
		StartLift = Broodwar->getFrameCount();
		ProdMan->Barracks[0]->lift();
		putBdown = true;
	}
	if( Broodwar->getFrameCount() - StartLift > 500 && putBdown == true){
		putBdown = false;
		ProdMan->Barracks[0]->land( bManager->BarracksWall ); 
	}

}

void GeneralManager::GateSCV(){


	if(  BarracksLift == true ){
	    if( ProdMan->Barracks[0]->getTrainingQueue().size() != 0){
		ProdMan->Barracks[0]->cancelTrain();
	    }
		//BarracksLift = false;
		//StartLift = Broodwar->getFrameCount();
		ProdMan->Barracks[0]->lift();
		//putBdown = true;
	}
	if(  BarracksLift == true && ProdMan->Barracks[0]->isLifted() ){
		BarracksLift = false;
		StartLift = Broodwar->getFrameCount();
		putBdown = true;
	}
	if( Broodwar->getFrameCount() - StartLift > 200 && putBdown == true){
		putBdown = false;
		if( bManager->WallSound == true ){
		  ProdMan->Barracks[0]->land( bManager->BarracksWall ); 
		} else {
			BWAPI::TilePosition tempMove = bManager->getBuildLocationNear( InfoMan->OurBase, BWAPI::UnitTypes::Terran_Barracks, BWTA::getRegion( InfoMan->PosOurBase ) ); 
	      bManager->mapArea( bManager->getBuildRectangle(tempMove, BWAPI::UnitTypes::Terran_Barracks) , 0,0 );
		  ProdMan->Barracks[0]->land( tempMove ); 
		}
	}


}

void GeneralManager::StartLiftBarracks(){

	if( onlyOnce ){
		return;
	}

	onlyOnce = true;
	stillLifting = true;
	toMove = bManager->getBuildLocationNear( bManager->BarracksWall, BWAPI::UnitTypes::Terran_Barracks, BWTA::getRegion( InfoMan->PosOurBase ) ); 
	bManager->mapArea( bManager->getBuildRectangle(toMove, BWAPI::UnitTypes::Terran_Barracks) , 0,0 );

}

void GeneralManager::onFrame(){

	if( CurrentStrategy == Wall_in ){
	  GateManage();
	}

	if( CurrentStrategy == One_Fact_3_Rax ){
		GateSCV();
	}

	//scout at 13 scvs
	if(  ScoutMan == NULL && Broodwar->self()->completedUnitCount( BWAPI::UnitTypes::Terran_SCV ) == 13
		&& CurrentStrategy != Wall_in ){
		ScoutMan = new ScoutManager(1);
	}

	if(  ScoutMan == NULL && Broodwar->self()->completedUnitCount( BWAPI::UnitTypes::Terran_SCV ) == 12
		&& CurrentStrategy == Wall_in ){
		ScoutMan = new ScoutManager(1);
	}

	if( CurrentStrategy == BBS && Broodwar->getFrameCount() > 15000 ){ //switch to wraiths to finish enemy off
		//ProdMan->BuildingsQueue.clear(); 
		CurrentStrategy = Normal_Wraith;
	}

	if( CurrentStrategy == One_Fact_3_Rax && stillLifting ){ //switch to wraiths to finish enemy off
		if(  ProdMan->Barracks[0]->getTilePosition() == toMove ){
			stillLifting = false;
		}
		if( !ProdMan->Barracks[0]->isLifted() ){
			ProdMan->Barracks[0]->lift();
		}
		if( ProdMan->Barracks[0]->isLifted() && ProdMan->Barracks[0]->getOrder() != BWAPI::Orders::BuildingLand ){
			ProdMan->Barracks[0]->land(  toMove );
		}
	}

	//push out at 42 supply
	if( CurrentStrategy == One_Fact_3_Rax && BioMan->BioS == Build_up 
		&& (Broodwar->self()->supplyUsed() > 90 || Broodwar->getFrameCount() > 10000) ){
		BioMan->BioS = Push_out;
		BioMan->NextBuilding();
		StartLiftBarracks();
	}

}