#include "Common.h"
#include "GasStealManager.h"
#include "InformationManager.h"


GasStealManager::GasStealManager()
{

	//gasStealSCV = gasSCV;

	//find the correct build location for the refinery
	int nearest = 9999999;
	BOOST_FOREACH( BWAPI::TilePosition gasPos, InfoMan->GeyserLocations ){
		if(  InfoMan->EnemyBase.getDistance( gasPos ) < nearest  ){
			nearest = InfoMan->EnemyBase.getDistance( gasPos );
			RefineryLoc =  gasPos;
		}
	}

	//get the scv closest to the enemy base
	BWAPI::Position gasPos = BWAPI::Position(RefineryLoc);
	int gasSCVID = -1;
	int scvClose = 99999;
	for(unsigned int i=0; i<ScoutMan->workerScouts.size(); i++){
		if( ScoutMan->workerScouts[i].scv->getDistance( gasPos ) < scvClose ){
			scvClose = ScoutMan->workerScouts[i].scv->getDistance( gasPos );
			gasSCVID = i;
		}
	}
	if(  gasSCVID != -1 ){
		gasStealSCV = ScoutMan->workerScouts[gasSCVID].scv;
		ScoutMan->workerScouts.erase( ScoutMan->workerScouts.begin() + gasSCVID );
	}

	ProdMan->reservedMinerals += 100;//refinery costs 100 minerals
	isBuilding = false;
	done = false;
}

void GasStealManager::OnFrame()
{
	if( gasStealSCV == NULL ){
	  //something went wrong, abort to prevent using a null pointer
		return;
	}
	if( done == true ){
		return;
	}
	if(  isBuilding == true ){
		//add the scv to the bunker rush once the refinery is complete
		if( Refinery != NULL ){
		  if( Refinery->isCompleted() ){
			BRMan->AddSCV( gasStealSCV );
			done = true;
		  }
		}
		return;
	}
	if( !gasStealSCV->exists() && isBuilding == false ){//if the scv is destoyed without building a refinery
		//treat the refinery as build
		isBuilding = true;
		ProdMan->reservedMinerals -= 100;
		return;
	}

	BWAPI::Position moveTo = BWAPI::Position( RefineryLoc );
	if(  !Broodwar->isVisible(  RefineryLoc ) ){
		gasStealSCV->move(moveTo);
	} else if ( Broodwar->isVisible( RefineryLoc ) && isBuilding == NULL ) {
		gasStealSCV->build( RefineryLoc , BWAPI::UnitTypes::Terran_Refinery );
	} 
	if( gasStealSCV->getBuildUnit() != NULL && isBuilding == false ){
		isBuilding = true;
		Refinery = gasStealSCV->getBuildUnit();
		ProdMan->reservedMinerals -= 100;
		//BRMan->AddSCV( gasStealSCV );//after the scv is done building, use it in the bunker rush
	}

}